package zio.aws.panorama.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateJobForDevicesResponse(
    jobs: Iterable[zio.aws.panorama.model.Job]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse = {
    import CreateJobForDevicesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse
      .builder()
      .jobs(jobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.CreateJobForDevicesResponse.ReadOnly =
    zio.aws.panorama.model.CreateJobForDevicesResponse.wrap(buildAwsValue())
}
object CreateJobForDevicesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreateJobForDevicesResponse =
      zio.aws.panorama.model.CreateJobForDevicesResponse(jobs.map { item =>
        item.asEditable
      })
    def jobs: List[zio.aws.panorama.model.Job.ReadOnly]
    def getJobs: ZIO[Any, Nothing, List[zio.aws.panorama.model.Job.ReadOnly]] =
      ZIO.succeed(jobs)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse
  ) extends zio.aws.panorama.model.CreateJobForDevicesResponse.ReadOnly {
    override val jobs: List[zio.aws.panorama.model.Job.ReadOnly] = impl
      .jobs()
      .asScala
      .map { item =>
        zio.aws.panorama.model.Job.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreateJobForDevicesResponse
  ): zio.aws.panorama.model.CreateJobForDevicesResponse.ReadOnly = new Wrapper(
    impl
  )
}
