package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  TemplateKey,
  NodePackageName,
  NodePackageVersion,
  Description,
  NodeName,
  TemplateValue
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateNodeFromTemplateJobRequest(
    jobTags: Optional[Iterable[zio.aws.panorama.model.JobResourceTags]] =
      Optional.Absent,
    nodeDescription: Optional[Description] = Optional.Absent,
    nodeName: NodeName,
    outputPackageName: NodePackageName,
    outputPackageVersion: NodePackageVersion,
    templateParameters: Map[TemplateKey, TemplateValue],
    templateType: zio.aws.panorama.model.TemplateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest = {
    import CreateNodeFromTemplateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest
      .builder()
      .optionallyWith(
        jobTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobTags)
      .optionallyWith(
        nodeDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.nodeDescription)
      .nodeName(NodeName.unwrap(nodeName): java.lang.String)
      .outputPackageName(
        NodePackageName.unwrap(outputPackageName): java.lang.String
      )
      .outputPackageVersion(
        NodePackageVersion.unwrap(outputPackageVersion): java.lang.String
      )
      .templateParameters(
        templateParameters
          .map({ case (key, value) =>
            (TemplateKey.unwrap(key): java.lang.String) -> (TemplateValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .templateType(templateType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.CreateNodeFromTemplateJobRequest.ReadOnly =
    zio.aws.panorama.model.CreateNodeFromTemplateJobRequest
      .wrap(buildAwsValue())
}
object CreateNodeFromTemplateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreateNodeFromTemplateJobRequest =
      zio.aws.panorama.model.CreateNodeFromTemplateJobRequest(
        jobTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nodeDescription.map(value => value),
        nodeName,
        outputPackageName,
        outputPackageVersion,
        templateParameters,
        templateType
      )
    def jobTags: Optional[List[zio.aws.panorama.model.JobResourceTags.ReadOnly]]
    def nodeDescription: Optional[Description]
    def nodeName: NodeName
    def outputPackageName: NodePackageName
    def outputPackageVersion: NodePackageVersion
    def templateParameters: Map[TemplateKey, TemplateValue]
    def templateType: zio.aws.panorama.model.TemplateType
    def getJobTags: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.JobResourceTags.ReadOnly
    ]] = AwsError.unwrapOptionField("jobTags", jobTags)
    def getNodeDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("nodeDescription", nodeDescription)
    def getNodeName: ZIO[Any, Nothing, NodeName] = ZIO.succeed(nodeName)
    def getOutputPackageName: ZIO[Any, Nothing, NodePackageName] =
      ZIO.succeed(outputPackageName)
    def getOutputPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(outputPackageVersion)
    def getTemplateParameters
        : ZIO[Any, Nothing, Map[TemplateKey, TemplateValue]] =
      ZIO.succeed(templateParameters)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.panorama.model.TemplateType] =
      ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest
  ) extends zio.aws.panorama.model.CreateNodeFromTemplateJobRequest.ReadOnly {
    override val jobTags
        : Optional[List[zio.aws.panorama.model.JobResourceTags.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.JobResourceTags.wrap(item)
          }.toList
        )
    override val nodeDescription: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeDescription())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val nodeName: NodeName =
      zio.aws.panorama.model.primitives.NodeName(impl.nodeName())
    override val outputPackageName: NodePackageName =
      zio.aws.panorama.model.primitives
        .NodePackageName(impl.outputPackageName())
    override val outputPackageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.outputPackageVersion())
    override val templateParameters: Map[TemplateKey, TemplateValue] = impl
      .templateParameters()
      .asScala
      .map({ case (key, value) =>
        zio.aws.panorama.model.primitives.TemplateKey(
          key
        ) -> zio.aws.panorama.model.primitives.TemplateValue(value)
      })
      .toMap
    override val templateType: zio.aws.panorama.model.TemplateType =
      zio.aws.panorama.model.TemplateType.wrap(impl.templateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobRequest
  ): zio.aws.panorama.model.CreateNodeFromTemplateJobRequest.ReadOnly =
    new Wrapper(impl)
}
