package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateNodeFromTemplateJobResponse(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse = {
    import CreateNodeFromTemplateJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.ReadOnly =
    zio.aws.panorama.model.CreateNodeFromTemplateJobResponse
      .wrap(buildAwsValue())
}
object CreateNodeFromTemplateJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreateNodeFromTemplateJobResponse =
      zio.aws.panorama.model.CreateNodeFromTemplateJobResponse(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse
  ) extends zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.panorama.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreateNodeFromTemplateJobResponse
  ): zio.aws.panorama.model.CreateNodeFromTemplateJobResponse.ReadOnly =
    new Wrapper(impl)
}
