package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ClientToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePackageImportJobRequest(
    clientToken: ClientToken,
    inputConfig: zio.aws.panorama.model.PackageImportJobInputConfig,
    jobTags: Optional[Iterable[zio.aws.panorama.model.JobResourceTags]] =
      Optional.Absent,
    jobType: zio.aws.panorama.model.PackageImportJobType,
    outputConfig: zio.aws.panorama.model.PackageImportJobOutputConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest = {
    import CreatePackageImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest
      .builder()
      .clientToken(ClientToken.unwrap(clientToken): java.lang.String)
      .inputConfig(inputConfig.buildAwsValue())
      .optionallyWith(
        jobTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobTags)
      .jobType(jobType.unwrap)
      .outputConfig(outputConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.CreatePackageImportJobRequest.ReadOnly =
    zio.aws.panorama.model.CreatePackageImportJobRequest.wrap(buildAwsValue())
}
object CreatePackageImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreatePackageImportJobRequest =
      zio.aws.panorama.model.CreatePackageImportJobRequest(
        clientToken,
        inputConfig.asEditable,
        jobTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jobType,
        outputConfig.asEditable
      )
    def clientToken: ClientToken
    def inputConfig: zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly
    def jobTags: Optional[List[zio.aws.panorama.model.JobResourceTags.ReadOnly]]
    def jobType: zio.aws.panorama.model.PackageImportJobType
    def outputConfig
        : zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly
    def getClientToken: ZIO[Any, Nothing, ClientToken] =
      ZIO.succeed(clientToken)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobTags: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.JobResourceTags.ReadOnly
    ]] = AwsError.unwrapOptionField("jobTags", jobTags)
    def getJobType
        : ZIO[Any, Nothing, zio.aws.panorama.model.PackageImportJobType] =
      ZIO.succeed(jobType)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest
  ) extends zio.aws.panorama.model.CreatePackageImportJobRequest.ReadOnly {
    override val clientToken: ClientToken =
      zio.aws.panorama.model.primitives.ClientToken(impl.clientToken())
    override val inputConfig
        : zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly =
      zio.aws.panorama.model.PackageImportJobInputConfig
        .wrap(impl.inputConfig())
    override val jobTags
        : Optional[List[zio.aws.panorama.model.JobResourceTags.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.JobResourceTags.wrap(item)
          }.toList
        )
    override val jobType: zio.aws.panorama.model.PackageImportJobType =
      zio.aws.panorama.model.PackageImportJobType.wrap(impl.jobType())
    override val outputConfig
        : zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly =
      zio.aws.panorama.model.PackageImportJobOutputConfig
        .wrap(impl.outputConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreatePackageImportJobRequest
  ): zio.aws.panorama.model.CreatePackageImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
