package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreatePackageImportJobResponse(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse = {
    import CreatePackageImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.CreatePackageImportJobResponse.ReadOnly =
    zio.aws.panorama.model.CreatePackageImportJobResponse.wrap(buildAwsValue())
}
object CreatePackageImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreatePackageImportJobResponse =
      zio.aws.panorama.model.CreatePackageImportJobResponse(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse
  ) extends zio.aws.panorama.model.CreatePackageImportJobResponse.ReadOnly {
    override val jobId: JobId =
      zio.aws.panorama.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreatePackageImportJobResponse
  ): zio.aws.panorama.model.CreatePackageImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
