package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{TagValue, TagKey, NodePackageName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePackageRequest(
    packageName: NodePackageName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreatePackageRequest = {
    import CreatePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreatePackageRequest
      .builder()
      .packageName(NodePackageName.unwrap(packageName): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.CreatePackageRequest.ReadOnly =
    zio.aws.panorama.model.CreatePackageRequest.wrap(buildAwsValue())
}
object CreatePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreatePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreatePackageRequest =
      zio.aws.panorama.model
        .CreatePackageRequest(packageName, tags.map(value => value))
    def packageName: NodePackageName
    def tags: Optional[Map[TagKey, TagValue]]
    def getPackageName: ZIO[Any, Nothing, NodePackageName] =
      ZIO.succeed(packageName)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreatePackageRequest
  ) extends zio.aws.panorama.model.CreatePackageRequest.ReadOnly {
    override val packageName: NodePackageName =
      zio.aws.panorama.model.primitives.NodePackageName(impl.packageName())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.panorama.model.primitives
              .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreatePackageRequest
  ): zio.aws.panorama.model.CreatePackageRequest.ReadOnly = new Wrapper(impl)
}
