package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{NodePackageId, NodePackageArn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreatePackageResponse(
    arn: Optional[NodePackageArn] = Optional.Absent,
    packageId: Optional[NodePackageId] = Optional.Absent,
    storageLocation: zio.aws.panorama.model.StorageLocation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.CreatePackageResponse = {
    import CreatePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.CreatePackageResponse
      .builder()
      .optionallyWith(
        arn.map(value => NodePackageArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        packageId.map(value => NodePackageId.unwrap(value): java.lang.String)
      )(_.packageId)
      .storageLocation(storageLocation.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.CreatePackageResponse.ReadOnly =
    zio.aws.panorama.model.CreatePackageResponse.wrap(buildAwsValue())
}
object CreatePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.CreatePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.CreatePackageResponse =
      zio.aws.panorama.model.CreatePackageResponse(
        arn.map(value => value),
        packageId.map(value => value),
        storageLocation.asEditable
      )
    def arn: Optional[NodePackageArn]
    def packageId: Optional[NodePackageId]
    def storageLocation: zio.aws.panorama.model.StorageLocation.ReadOnly
    def getArn: ZIO[Any, AwsError, NodePackageArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getPackageId: ZIO[Any, AwsError, NodePackageId] =
      AwsError.unwrapOptionField("packageId", packageId)
    def getStorageLocation
        : ZIO[Any, Nothing, zio.aws.panorama.model.StorageLocation.ReadOnly] =
      ZIO.succeed(storageLocation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.CreatePackageResponse
  ) extends zio.aws.panorama.model.CreatePackageResponse.ReadOnly {
    override val arn: Optional[NodePackageArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.panorama.model.primitives.NodePackageArn(value))
    override val packageId: Optional[NodePackageId] = zio.aws.core.internal
      .optionalFromNullable(impl.packageId())
      .map(value => zio.aws.panorama.model.primitives.NodePackageId(value))
    override val storageLocation
        : zio.aws.panorama.model.StorageLocation.ReadOnly =
      zio.aws.panorama.model.StorageLocation.wrap(impl.storageLocation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.CreatePackageResponse
  ): zio.aws.panorama.model.CreatePackageResponse.ReadOnly = new Wrapper(impl)
}
