package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.DeviceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteDeviceRequest(deviceId: DeviceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest = {
    import DeleteDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest
      .builder()
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DeleteDeviceRequest.ReadOnly =
    zio.aws.panorama.model.DeleteDeviceRequest.wrap(buildAwsValue())
}
object DeleteDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DeleteDeviceRequest =
      zio.aws.panorama.model.DeleteDeviceRequest(deviceId)
    def deviceId: DeviceId
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest
  ) extends zio.aws.panorama.model.DeleteDeviceRequest.ReadOnly {
    override val deviceId: DeviceId =
      zio.aws.panorama.model.primitives.DeviceId(impl.deviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DeleteDeviceRequest
  ): zio.aws.panorama.model.DeleteDeviceRequest.ReadOnly = new Wrapper(impl)
}
