package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.DeviceId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteDeviceResponse(
    deviceId: Optional[DeviceId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse = {
    import DeleteDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse
      .builder()
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DeleteDeviceResponse.ReadOnly =
    zio.aws.panorama.model.DeleteDeviceResponse.wrap(buildAwsValue())
}
object DeleteDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DeleteDeviceResponse =
      zio.aws.panorama.model.DeleteDeviceResponse(deviceId.map(value => value))
    def deviceId: Optional[DeviceId]
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse
  ) extends zio.aws.panorama.model.DeleteDeviceResponse.ReadOnly {
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DeleteDeviceResponse
  ): zio.aws.panorama.model.DeleteDeviceResponse.ReadOnly = new Wrapper(impl)
}
