package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NodePackageId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeletePackageRequest(
    forceDelete: Optional[Boolean] = Optional.Absent,
    packageId: NodePackageId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DeletePackageRequest = {
    import DeletePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DeletePackageRequest
      .builder()
      .optionallyWith(forceDelete.map(value => value: java.lang.Boolean))(
        _.forceDelete
      )
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DeletePackageRequest.ReadOnly =
    zio.aws.panorama.model.DeletePackageRequest.wrap(buildAwsValue())
}
object DeletePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DeletePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DeletePackageRequest =
      zio.aws.panorama.model
        .DeletePackageRequest(forceDelete.map(value => value), packageId)
    def forceDelete: Optional[Boolean]
    def packageId: NodePackageId
    def getForceDelete: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("forceDelete", forceDelete)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DeletePackageRequest
  ) extends zio.aws.panorama.model.DeletePackageRequest.ReadOnly {
    override val forceDelete: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.forceDelete())
      .map(value => value: Boolean)
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DeletePackageRequest
  ): zio.aws.panorama.model.DeletePackageRequest.ReadOnly = new Wrapper(impl)
}
