package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  NodePackagePatchVersion,
  NodePackageVersion,
  NodePackageId,
  PackageOwnerAccount
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeregisterPackageVersionRequest(
    ownerAccount: Optional[PackageOwnerAccount] = Optional.Absent,
    packageId: NodePackageId,
    packageVersion: NodePackageVersion,
    patchVersion: NodePackagePatchVersion,
    updatedLatestPatchVersion: Optional[NodePackagePatchVersion] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest = {
    import DeregisterPackageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest
      .builder()
      .optionallyWith(
        ownerAccount.map(value =>
          PackageOwnerAccount.unwrap(value): java.lang.String
        )
      )(_.ownerAccount)
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .patchVersion(
        NodePackagePatchVersion.unwrap(patchVersion): java.lang.String
      )
      .optionallyWith(
        updatedLatestPatchVersion.map(value =>
          NodePackagePatchVersion.unwrap(value): java.lang.String
        )
      )(_.updatedLatestPatchVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DeregisterPackageVersionRequest.ReadOnly =
    zio.aws.panorama.model.DeregisterPackageVersionRequest.wrap(buildAwsValue())
}
object DeregisterPackageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DeregisterPackageVersionRequest =
      zio.aws.panorama.model.DeregisterPackageVersionRequest(
        ownerAccount.map(value => value),
        packageId,
        packageVersion,
        patchVersion,
        updatedLatestPatchVersion.map(value => value)
      )
    def ownerAccount: Optional[PackageOwnerAccount]
    def packageId: NodePackageId
    def packageVersion: NodePackageVersion
    def patchVersion: NodePackagePatchVersion
    def updatedLatestPatchVersion: Optional[NodePackagePatchVersion]
    def getOwnerAccount: ZIO[Any, AwsError, PackageOwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
    def getPatchVersion: ZIO[Any, Nothing, NodePackagePatchVersion] =
      ZIO.succeed(patchVersion)
    def getUpdatedLatestPatchVersion
        : ZIO[Any, AwsError, NodePackagePatchVersion] = AwsError
      .unwrapOptionField("updatedLatestPatchVersion", updatedLatestPatchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest
  ) extends zio.aws.panorama.model.DeregisterPackageVersionRequest.ReadOnly {
    override val ownerAccount: Optional[PackageOwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAccount())
        .map(value =>
          zio.aws.panorama.model.primitives.PackageOwnerAccount(value)
        )
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
    override val patchVersion: NodePackagePatchVersion =
      zio.aws.panorama.model.primitives
        .NodePackagePatchVersion(impl.patchVersion())
    override val updatedLatestPatchVersion: Optional[NodePackagePatchVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.updatedLatestPatchVersion())
        .map(value =>
          zio.aws.panorama.model.primitives.NodePackagePatchVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DeregisterPackageVersionRequest
  ): zio.aws.panorama.model.DeregisterPackageVersionRequest.ReadOnly =
    new Wrapper(impl)
}
