package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ApplicationInstanceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeApplicationInstanceDetailsRequest(
    applicationInstanceId: ApplicationInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest = {
    import DescribeApplicationInstanceDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest
      .builder()
      .applicationInstanceId(
        ApplicationInstanceId.unwrap(applicationInstanceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribeApplicationInstanceDetailsRequest.ReadOnly =
    zio.aws.panorama.model.DescribeApplicationInstanceDetailsRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationInstanceDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.panorama.model.DescribeApplicationInstanceDetailsRequest =
      zio.aws.panorama.model
        .DescribeApplicationInstanceDetailsRequest(applicationInstanceId)
    def applicationInstanceId: ApplicationInstanceId
    def getApplicationInstanceId: ZIO[Any, Nothing, ApplicationInstanceId] =
      ZIO.succeed(applicationInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest
  ) extends zio.aws.panorama.model.DescribeApplicationInstanceDetailsRequest.ReadOnly {
    override val applicationInstanceId: ApplicationInstanceId =
      zio.aws.panorama.model.primitives
        .ApplicationInstanceId(impl.applicationInstanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsRequest
  ): zio.aws.panorama.model.DescribeApplicationInstanceDetailsRequest.ReadOnly =
    new Wrapper(impl)
}
