package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  ApplicationInstanceName,
  Description,
  ApplicationInstanceId,
  TimeStamp,
  DefaultRuntimeContextDevice
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeApplicationInstanceDetailsResponse(
    applicationInstanceId: Optional[ApplicationInstanceId] = Optional.Absent,
    applicationInstanceIdToReplace: Optional[ApplicationInstanceId] =
      Optional.Absent,
    createdTime: Optional[TimeStamp] = Optional.Absent,
    defaultRuntimeContextDevice: Optional[DefaultRuntimeContextDevice] =
      Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    manifestOverridesPayload: Optional[
      zio.aws.panorama.model.ManifestOverridesPayload
    ] = Optional.Absent,
    manifestPayload: Optional[zio.aws.panorama.model.ManifestPayload] =
      Optional.Absent,
    name: Optional[ApplicationInstanceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse = {
    import DescribeApplicationInstanceDetailsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse
      .builder()
      .optionallyWith(
        applicationInstanceId.map(value =>
          ApplicationInstanceId.unwrap(value): java.lang.String
        )
      )(_.applicationInstanceId)
      .optionallyWith(
        applicationInstanceIdToReplace.map(value =>
          ApplicationInstanceId.unwrap(value): java.lang.String
        )
      )(_.applicationInstanceIdToReplace)
      .optionallyWith(
        createdTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        defaultRuntimeContextDevice.map(value =>
          DefaultRuntimeContextDevice.unwrap(value): java.lang.String
        )
      )(_.defaultRuntimeContextDevice)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        manifestOverridesPayload.map(value => value.buildAwsValue())
      )(_.manifestOverridesPayload)
      .optionallyWith(manifestPayload.map(value => value.buildAwsValue()))(
        _.manifestPayload
      )
      .optionallyWith(
        name.map(value =>
          ApplicationInstanceName.unwrap(value): java.lang.String
        )
      )(_.name)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.ReadOnly =
    zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationInstanceDetailsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse =
      zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse(
        applicationInstanceId.map(value => value),
        applicationInstanceIdToReplace.map(value => value),
        createdTime.map(value => value),
        defaultRuntimeContextDevice.map(value => value),
        description.map(value => value),
        manifestOverridesPayload.map(value => value.asEditable),
        manifestPayload.map(value => value.asEditable),
        name.map(value => value)
      )
    def applicationInstanceId: Optional[ApplicationInstanceId]
    def applicationInstanceIdToReplace: Optional[ApplicationInstanceId]
    def createdTime: Optional[TimeStamp]
    def defaultRuntimeContextDevice: Optional[DefaultRuntimeContextDevice]
    def description: Optional[Description]
    def manifestOverridesPayload
        : Optional[zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly]
    def manifestPayload
        : Optional[zio.aws.panorama.model.ManifestPayload.ReadOnly]
    def name: Optional[ApplicationInstanceName]
    def getApplicationInstanceId: ZIO[Any, AwsError, ApplicationInstanceId] =
      AwsError.unwrapOptionField("applicationInstanceId", applicationInstanceId)
    def getApplicationInstanceIdToReplace
        : ZIO[Any, AwsError, ApplicationInstanceId] =
      AwsError.unwrapOptionField(
        "applicationInstanceIdToReplace",
        applicationInstanceIdToReplace
      )
    def getCreatedTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDefaultRuntimeContextDevice
        : ZIO[Any, AwsError, DefaultRuntimeContextDevice] =
      AwsError.unwrapOptionField(
        "defaultRuntimeContextDevice",
        defaultRuntimeContextDevice
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getManifestOverridesPayload: ZIO[
      Any,
      AwsError,
      zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly
    ] = AwsError.unwrapOptionField(
      "manifestOverridesPayload",
      manifestOverridesPayload
    )
    def getManifestPayload
        : ZIO[Any, AwsError, zio.aws.panorama.model.ManifestPayload.ReadOnly] =
      AwsError.unwrapOptionField("manifestPayload", manifestPayload)
    def getName: ZIO[Any, AwsError, ApplicationInstanceName] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse
  ) extends zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.ReadOnly {
    override val applicationInstanceId: Optional[ApplicationInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationInstanceId())
        .map(value =>
          zio.aws.panorama.model.primitives.ApplicationInstanceId(value)
        )
    override val applicationInstanceIdToReplace
        : Optional[ApplicationInstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationInstanceIdToReplace())
      .map(value =>
        zio.aws.panorama.model.primitives.ApplicationInstanceId(value)
      )
    override val createdTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.panorama.model.primitives.TimeStamp(value))
    override val defaultRuntimeContextDevice
        : Optional[DefaultRuntimeContextDevice] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultRuntimeContextDevice())
      .map(value =>
        zio.aws.panorama.model.primitives.DefaultRuntimeContextDevice(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val manifestOverridesPayload
        : Optional[zio.aws.panorama.model.ManifestOverridesPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestOverridesPayload())
        .map(value =>
          zio.aws.panorama.model.ManifestOverridesPayload.wrap(value)
        )
    override val manifestPayload
        : Optional[zio.aws.panorama.model.ManifestPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestPayload())
        .map(value => zio.aws.panorama.model.ManifestPayload.wrap(value))
    override val name: Optional[ApplicationInstanceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.panorama.model.primitives.ApplicationInstanceName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceDetailsResponse
  ): zio.aws.panorama.model.DescribeApplicationInstanceDetailsResponse.ReadOnly =
    new Wrapper(impl)
}
