package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ApplicationInstanceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeApplicationInstanceRequest(
    applicationInstanceId: ApplicationInstanceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest = {
    import DescribeApplicationInstanceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest
      .builder()
      .applicationInstanceId(
        ApplicationInstanceId.unwrap(applicationInstanceId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribeApplicationInstanceRequest.ReadOnly =
    zio.aws.panorama.model.DescribeApplicationInstanceRequest
      .wrap(buildAwsValue())
}
object DescribeApplicationInstanceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeApplicationInstanceRequest =
      zio.aws.panorama.model
        .DescribeApplicationInstanceRequest(applicationInstanceId)
    def applicationInstanceId: ApplicationInstanceId
    def getApplicationInstanceId: ZIO[Any, Nothing, ApplicationInstanceId] =
      ZIO.succeed(applicationInstanceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest
  ) extends zio.aws.panorama.model.DescribeApplicationInstanceRequest.ReadOnly {
    override val applicationInstanceId: ApplicationInstanceId =
      zio.aws.panorama.model.primitives
        .ApplicationInstanceId(impl.applicationInstanceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceRequest
  ): zio.aws.panorama.model.DescribeApplicationInstanceRequest.ReadOnly =
    new Wrapper(impl)
}
