package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  ApplicationInstanceName,
  DeviceName,
  ApplicationInstanceStatusDescription,
  TagValue,
  Description,
  RuntimeRoleArn,
  ApplicationInstanceId,
  ApplicationInstanceArn,
  TimeStamp,
  DefaultRuntimeContextDevice,
  TagKey
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeApplicationInstanceResponse(
    applicationInstanceId: Optional[ApplicationInstanceId] = Optional.Absent,
    applicationInstanceIdToReplace: Optional[ApplicationInstanceId] =
      Optional.Absent,
    arn: Optional[ApplicationInstanceArn] = Optional.Absent,
    createdTime: Optional[TimeStamp] = Optional.Absent,
    defaultRuntimeContextDevice: Optional[DefaultRuntimeContextDevice] =
      Optional.Absent,
    defaultRuntimeContextDeviceName: Optional[DeviceName] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    healthStatus: Optional[
      zio.aws.panorama.model.ApplicationInstanceHealthStatus
    ] = Optional.Absent,
    lastUpdatedTime: Optional[TimeStamp] = Optional.Absent,
    name: Optional[ApplicationInstanceName] = Optional.Absent,
    runtimeContextStates: Optional[
      Iterable[zio.aws.panorama.model.ReportedRuntimeContextState]
    ] = Optional.Absent,
    runtimeRoleArn: Optional[RuntimeRoleArn] = Optional.Absent,
    status: Optional[zio.aws.panorama.model.ApplicationInstanceStatus] =
      Optional.Absent,
    statusDescription: Optional[ApplicationInstanceStatusDescription] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse = {
    import DescribeApplicationInstanceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse
      .builder()
      .optionallyWith(
        applicationInstanceId.map(value =>
          ApplicationInstanceId.unwrap(value): java.lang.String
        )
      )(_.applicationInstanceId)
      .optionallyWith(
        applicationInstanceIdToReplace.map(value =>
          ApplicationInstanceId.unwrap(value): java.lang.String
        )
      )(_.applicationInstanceIdToReplace)
      .optionallyWith(
        arn.map(value => ApplicationInstanceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(
        createdTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        defaultRuntimeContextDevice.map(value =>
          DefaultRuntimeContextDevice.unwrap(value): java.lang.String
        )
      )(_.defaultRuntimeContextDevice)
      .optionallyWith(
        defaultRuntimeContextDeviceName.map(value =>
          DeviceName.unwrap(value): java.lang.String
        )
      )(_.defaultRuntimeContextDeviceName)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(healthStatus.map(value => value.unwrap))(_.healthStatus)
      .optionallyWith(
        lastUpdatedTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(
        name.map(value =>
          ApplicationInstanceName.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(
        runtimeContextStates.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.runtimeContextStates)
      .optionallyWith(
        runtimeRoleArn.map(value =>
          RuntimeRoleArn.unwrap(value): java.lang.String
        )
      )(_.runtimeRoleArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusDescription.map(value =>
          ApplicationInstanceStatusDescription.unwrap(value): java.lang.String
        )
      )(_.statusDescription)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribeApplicationInstanceResponse.ReadOnly =
    zio.aws.panorama.model.DescribeApplicationInstanceResponse
      .wrap(buildAwsValue())
}
object DescribeApplicationInstanceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeApplicationInstanceResponse =
      zio.aws.panorama.model.DescribeApplicationInstanceResponse(
        applicationInstanceId.map(value => value),
        applicationInstanceIdToReplace.map(value => value),
        arn.map(value => value),
        createdTime.map(value => value),
        defaultRuntimeContextDevice.map(value => value),
        defaultRuntimeContextDeviceName.map(value => value),
        description.map(value => value),
        healthStatus.map(value => value),
        lastUpdatedTime.map(value => value),
        name.map(value => value),
        runtimeContextStates.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        runtimeRoleArn.map(value => value),
        status.map(value => value),
        statusDescription.map(value => value),
        tags.map(value => value)
      )
    def applicationInstanceId: Optional[ApplicationInstanceId]
    def applicationInstanceIdToReplace: Optional[ApplicationInstanceId]
    def arn: Optional[ApplicationInstanceArn]
    def createdTime: Optional[TimeStamp]
    def defaultRuntimeContextDevice: Optional[DefaultRuntimeContextDevice]
    def defaultRuntimeContextDeviceName: Optional[DeviceName]
    def description: Optional[Description]
    def healthStatus
        : Optional[zio.aws.panorama.model.ApplicationInstanceHealthStatus]
    def lastUpdatedTime: Optional[TimeStamp]
    def name: Optional[ApplicationInstanceName]
    def runtimeContextStates: Optional[
      List[zio.aws.panorama.model.ReportedRuntimeContextState.ReadOnly]
    ]
    def runtimeRoleArn: Optional[RuntimeRoleArn]
    def status: Optional[zio.aws.panorama.model.ApplicationInstanceStatus]
    def statusDescription: Optional[ApplicationInstanceStatusDescription]
    def tags: Optional[Map[TagKey, TagValue]]
    def getApplicationInstanceId: ZIO[Any, AwsError, ApplicationInstanceId] =
      AwsError.unwrapOptionField("applicationInstanceId", applicationInstanceId)
    def getApplicationInstanceIdToReplace
        : ZIO[Any, AwsError, ApplicationInstanceId] =
      AwsError.unwrapOptionField(
        "applicationInstanceIdToReplace",
        applicationInstanceIdToReplace
      )
    def getArn: ZIO[Any, AwsError, ApplicationInstanceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getCreatedTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDefaultRuntimeContextDevice
        : ZIO[Any, AwsError, DefaultRuntimeContextDevice] =
      AwsError.unwrapOptionField(
        "defaultRuntimeContextDevice",
        defaultRuntimeContextDevice
      )
    def getDefaultRuntimeContextDeviceName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField(
        "defaultRuntimeContextDeviceName",
        defaultRuntimeContextDeviceName
      )
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getHealthStatus: ZIO[
      Any,
      AwsError,
      zio.aws.panorama.model.ApplicationInstanceHealthStatus
    ] = AwsError.unwrapOptionField("healthStatus", healthStatus)
    def getLastUpdatedTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getName: ZIO[Any, AwsError, ApplicationInstanceName] =
      AwsError.unwrapOptionField("name", name)
    def getRuntimeContextStates: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.ReportedRuntimeContextState.ReadOnly
    ]] =
      AwsError.unwrapOptionField("runtimeContextStates", runtimeContextStates)
    def getRuntimeRoleArn: ZIO[Any, AwsError, RuntimeRoleArn] =
      AwsError.unwrapOptionField("runtimeRoleArn", runtimeRoleArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.ApplicationInstanceStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusDescription
        : ZIO[Any, AwsError, ApplicationInstanceStatusDescription] =
      AwsError.unwrapOptionField("statusDescription", statusDescription)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse
  ) extends zio.aws.panorama.model.DescribeApplicationInstanceResponse.ReadOnly {
    override val applicationInstanceId: Optional[ApplicationInstanceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.applicationInstanceId())
        .map(value =>
          zio.aws.panorama.model.primitives.ApplicationInstanceId(value)
        )
    override val applicationInstanceIdToReplace
        : Optional[ApplicationInstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationInstanceIdToReplace())
      .map(value =>
        zio.aws.panorama.model.primitives.ApplicationInstanceId(value)
      )
    override val arn: Optional[ApplicationInstanceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.panorama.model.primitives.ApplicationInstanceArn(value)
      )
    override val createdTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.panorama.model.primitives.TimeStamp(value))
    override val defaultRuntimeContextDevice
        : Optional[DefaultRuntimeContextDevice] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultRuntimeContextDevice())
      .map(value =>
        zio.aws.panorama.model.primitives.DefaultRuntimeContextDevice(value)
      )
    override val defaultRuntimeContextDeviceName: Optional[DeviceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultRuntimeContextDeviceName())
        .map(value => zio.aws.panorama.model.primitives.DeviceName(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val healthStatus
        : Optional[zio.aws.panorama.model.ApplicationInstanceHealthStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthStatus())
        .map(value =>
          zio.aws.panorama.model.ApplicationInstanceHealthStatus.wrap(value)
        )
    override val lastUpdatedTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedTime())
      .map(value => zio.aws.panorama.model.primitives.TimeStamp(value))
    override val name: Optional[ApplicationInstanceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value =>
        zio.aws.panorama.model.primitives.ApplicationInstanceName(value)
      )
    override val runtimeContextStates: Optional[
      List[zio.aws.panorama.model.ReportedRuntimeContextState.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.runtimeContextStates())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.panorama.model.ReportedRuntimeContextState.wrap(item)
        }.toList
      )
    override val runtimeRoleArn: Optional[RuntimeRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.runtimeRoleArn())
        .map(value => zio.aws.panorama.model.primitives.RuntimeRoleArn(value))
    override val status
        : Optional[zio.aws.panorama.model.ApplicationInstanceStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.panorama.model.ApplicationInstanceStatus.wrap(value)
        )
    override val statusDescription
        : Optional[ApplicationInstanceStatusDescription] = zio.aws.core.internal
      .optionalFromNullable(impl.statusDescription())
      .map(value =>
        zio.aws.panorama.model.primitives
          .ApplicationInstanceStatusDescription(value)
      )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.panorama.model.primitives
              .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeApplicationInstanceResponse
  ): zio.aws.panorama.model.DescribeApplicationInstanceResponse.ReadOnly =
    new Wrapper(impl)
}
