package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDeviceJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest = {
    import DescribeDeviceJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DescribeDeviceJobRequest.ReadOnly =
    zio.aws.panorama.model.DescribeDeviceJobRequest.wrap(buildAwsValue())
}
object DescribeDeviceJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeDeviceJobRequest =
      zio.aws.panorama.model.DescribeDeviceJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest
  ) extends zio.aws.panorama.model.DescribeDeviceJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.panorama.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeDeviceJobRequest
  ): zio.aws.panorama.model.DescribeDeviceJobRequest.ReadOnly = new Wrapper(
    impl
  )
}
