package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  DeviceArn,
  DeviceName,
  DeviceId,
  ImageVersion,
  UpdateCreatedTime,
  JobId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDeviceJobResponse(
    createdTime: Optional[UpdateCreatedTime] = Optional.Absent,
    deviceArn: Optional[DeviceArn] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    deviceName: Optional[DeviceName] = Optional.Absent,
    deviceType: Optional[zio.aws.panorama.model.DeviceType] = Optional.Absent,
    imageVersion: Optional[ImageVersion] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    jobType: Optional[zio.aws.panorama.model.JobType] = Optional.Absent,
    status: Optional[zio.aws.panorama.model.UpdateProgress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse = {
    import DescribeDeviceJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse
      .builder()
      .optionallyWith(
        createdTime.map(value => UpdateCreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        deviceArn.map(value => DeviceArn.unwrap(value): java.lang.String)
      )(_.deviceArn)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        deviceName.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(deviceType.map(value => value.unwrap))(_.deviceType)
      .optionallyWith(
        imageVersion.map(value => ImageVersion.unwrap(value): java.lang.String)
      )(_.imageVersion)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DescribeDeviceJobResponse.ReadOnly =
    zio.aws.panorama.model.DescribeDeviceJobResponse.wrap(buildAwsValue())
}
object DescribeDeviceJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeDeviceJobResponse =
      zio.aws.panorama.model.DescribeDeviceJobResponse(
        createdTime.map(value => value),
        deviceArn.map(value => value),
        deviceId.map(value => value),
        deviceName.map(value => value),
        deviceType.map(value => value),
        imageVersion.map(value => value),
        jobId.map(value => value),
        jobType.map(value => value),
        status.map(value => value)
      )
    def createdTime: Optional[UpdateCreatedTime]
    def deviceArn: Optional[DeviceArn]
    def deviceId: Optional[DeviceId]
    def deviceName: Optional[DeviceName]
    def deviceType: Optional[zio.aws.panorama.model.DeviceType]
    def imageVersion: Optional[ImageVersion]
    def jobId: Optional[JobId]
    def jobType: Optional[zio.aws.panorama.model.JobType]
    def status: Optional[zio.aws.panorama.model.UpdateProgress]
    def getCreatedTime: ZIO[Any, AwsError, UpdateCreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDeviceArn: ZIO[Any, AwsError, DeviceArn] =
      AwsError.unwrapOptionField("deviceArn", deviceArn)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getDeviceName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getDeviceType: ZIO[Any, AwsError, zio.aws.panorama.model.DeviceType] =
      AwsError.unwrapOptionField("deviceType", deviceType)
    def getImageVersion: ZIO[Any, AwsError, ImageVersion] =
      AwsError.unwrapOptionField("imageVersion", imageVersion)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobType: ZIO[Any, AwsError, zio.aws.panorama.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getStatus: ZIO[Any, AwsError, zio.aws.panorama.model.UpdateProgress] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse
  ) extends zio.aws.panorama.model.DescribeDeviceJobResponse.ReadOnly {
    override val createdTime: Optional[UpdateCreatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTime())
        .map(value =>
          zio.aws.panorama.model.primitives.UpdateCreatedTime(value)
        )
    override val deviceArn: Optional[DeviceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceArn())
      .map(value => zio.aws.panorama.model.primitives.DeviceArn(value))
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
    override val deviceName: Optional[DeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.panorama.model.primitives.DeviceName(value))
    override val deviceType: Optional[zio.aws.panorama.model.DeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceType())
        .map(value => zio.aws.panorama.model.DeviceType.wrap(value))
    override val imageVersion: Optional[ImageVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.imageVersion())
      .map(value => zio.aws.panorama.model.primitives.ImageVersion(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.panorama.model.primitives.JobId(value))
    override val jobType: Optional[zio.aws.panorama.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.panorama.model.JobType.wrap(value))
    override val status: Optional[zio.aws.panorama.model.UpdateProgress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.panorama.model.UpdateProgress.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeDeviceJobResponse
  ): zio.aws.panorama.model.DescribeDeviceJobResponse.ReadOnly = new Wrapper(
    impl
  )
}
