package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.DeviceId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeDeviceRequest(deviceId: DeviceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest = {
    import DescribeDeviceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest
      .builder()
      .deviceId(DeviceId.unwrap(deviceId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DescribeDeviceRequest.ReadOnly =
    zio.aws.panorama.model.DescribeDeviceRequest.wrap(buildAwsValue())
}
object DescribeDeviceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeDeviceRequest =
      zio.aws.panorama.model.DescribeDeviceRequest(deviceId)
    def deviceId: DeviceId
    def getDeviceId: ZIO[Any, Nothing, DeviceId] = ZIO.succeed(deviceId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest
  ) extends zio.aws.panorama.model.DescribeDeviceRequest.ReadOnly {
    override val deviceId: DeviceId =
      zio.aws.panorama.model.primitives.DeviceId(impl.deviceId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeDeviceRequest
  ): zio.aws.panorama.model.DescribeDeviceRequest.ReadOnly = new Wrapper(impl)
}
