package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  LatestAlternateSoftware,
  LeaseExpirationTime,
  DeviceArn,
  DeviceName,
  DeviceId,
  TagValue,
  CurrentSoftware,
  DeviceSerialNumber,
  Description,
  LatestSoftware,
  CreatedTime,
  TagKey
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeDeviceResponse(
    alternateSoftwares: Optional[
      Iterable[zio.aws.panorama.model.AlternateSoftwareMetadata]
    ] = Optional.Absent,
    arn: Optional[DeviceArn] = Optional.Absent,
    brand: Optional[zio.aws.panorama.model.DeviceBrand] = Optional.Absent,
    createdTime: Optional[CreatedTime] = Optional.Absent,
    currentNetworkingStatus: Optional[zio.aws.panorama.model.NetworkStatus] =
      Optional.Absent,
    currentSoftware: Optional[CurrentSoftware] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    deviceAggregatedStatus: Optional[
      zio.aws.panorama.model.DeviceAggregatedStatus
    ] = Optional.Absent,
    deviceConnectionStatus: Optional[
      zio.aws.panorama.model.DeviceConnectionStatus
    ] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    latestAlternateSoftware: Optional[LatestAlternateSoftware] =
      Optional.Absent,
    latestDeviceJob: Optional[zio.aws.panorama.model.LatestDeviceJob] =
      Optional.Absent,
    latestSoftware: Optional[LatestSoftware] = Optional.Absent,
    leaseExpirationTime: Optional[LeaseExpirationTime] = Optional.Absent,
    name: Optional[DeviceName] = Optional.Absent,
    networkingConfiguration: Optional[zio.aws.panorama.model.NetworkPayload] =
      Optional.Absent,
    provisioningStatus: Optional[zio.aws.panorama.model.DeviceStatus] =
      Optional.Absent,
    serialNumber: Optional[DeviceSerialNumber] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: Optional[zio.aws.panorama.model.DeviceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse = {
    import DescribeDeviceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse
      .builder()
      .optionallyWith(
        alternateSoftwares.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.alternateSoftwares)
      .optionallyWith(
        arn.map(value => DeviceArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(brand.map(value => value.unwrap))(_.brand)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        currentNetworkingStatus.map(value => value.buildAwsValue())
      )(_.currentNetworkingStatus)
      .optionallyWith(
        currentSoftware.map(value =>
          CurrentSoftware.unwrap(value): java.lang.String
        )
      )(_.currentSoftware)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(deviceAggregatedStatus.map(value => value.unwrap))(
        _.deviceAggregatedStatus
      )
      .optionallyWith(deviceConnectionStatus.map(value => value.unwrap))(
        _.deviceConnectionStatus
      )
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        latestAlternateSoftware.map(value =>
          LatestAlternateSoftware.unwrap(value): java.lang.String
        )
      )(_.latestAlternateSoftware)
      .optionallyWith(latestDeviceJob.map(value => value.buildAwsValue()))(
        _.latestDeviceJob
      )
      .optionallyWith(
        latestSoftware.map(value =>
          LatestSoftware.unwrap(value): java.lang.String
        )
      )(_.latestSoftware)
      .optionallyWith(
        leaseExpirationTime.map(value =>
          LeaseExpirationTime.unwrap(value): Instant
        )
      )(_.leaseExpirationTime)
      .optionallyWith(
        name.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        networkingConfiguration.map(value => value.buildAwsValue())
      )(_.networkingConfiguration)
      .optionallyWith(provisioningStatus.map(value => value.unwrap))(
        _.provisioningStatus
      )
      .optionallyWith(
        serialNumber.map(value =>
          DeviceSerialNumber.unwrap(value): java.lang.String
        )
      )(_.serialNumber)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DescribeDeviceResponse.ReadOnly =
    zio.aws.panorama.model.DescribeDeviceResponse.wrap(buildAwsValue())
}
object DescribeDeviceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeDeviceResponse =
      zio.aws.panorama.model.DescribeDeviceResponse(
        alternateSoftwares.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        arn.map(value => value),
        brand.map(value => value),
        createdTime.map(value => value),
        currentNetworkingStatus.map(value => value.asEditable),
        currentSoftware.map(value => value),
        description.map(value => value),
        deviceAggregatedStatus.map(value => value),
        deviceConnectionStatus.map(value => value),
        deviceId.map(value => value),
        latestAlternateSoftware.map(value => value),
        latestDeviceJob.map(value => value.asEditable),
        latestSoftware.map(value => value),
        leaseExpirationTime.map(value => value),
        name.map(value => value),
        networkingConfiguration.map(value => value.asEditable),
        provisioningStatus.map(value => value),
        serialNumber.map(value => value),
        tags.map(value => value),
        `type`.map(value => value)
      )
    def alternateSoftwares: Optional[
      List[zio.aws.panorama.model.AlternateSoftwareMetadata.ReadOnly]
    ]
    def arn: Optional[DeviceArn]
    def brand: Optional[zio.aws.panorama.model.DeviceBrand]
    def createdTime: Optional[CreatedTime]
    def currentNetworkingStatus
        : Optional[zio.aws.panorama.model.NetworkStatus.ReadOnly]
    def currentSoftware: Optional[CurrentSoftware]
    def description: Optional[Description]
    def deviceAggregatedStatus
        : Optional[zio.aws.panorama.model.DeviceAggregatedStatus]
    def deviceConnectionStatus
        : Optional[zio.aws.panorama.model.DeviceConnectionStatus]
    def deviceId: Optional[DeviceId]
    def latestAlternateSoftware: Optional[LatestAlternateSoftware]
    def latestDeviceJob
        : Optional[zio.aws.panorama.model.LatestDeviceJob.ReadOnly]
    def latestSoftware: Optional[LatestSoftware]
    def leaseExpirationTime: Optional[LeaseExpirationTime]
    def name: Optional[DeviceName]
    def networkingConfiguration
        : Optional[zio.aws.panorama.model.NetworkPayload.ReadOnly]
    def provisioningStatus: Optional[zio.aws.panorama.model.DeviceStatus]
    def serialNumber: Optional[DeviceSerialNumber]
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: Optional[zio.aws.panorama.model.DeviceType]
    def getAlternateSoftwares: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.AlternateSoftwareMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("alternateSoftwares", alternateSoftwares)
    def getArn: ZIO[Any, AwsError, DeviceArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getBrand: ZIO[Any, AwsError, zio.aws.panorama.model.DeviceBrand] =
      AwsError.unwrapOptionField("brand", brand)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getCurrentNetworkingStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.NetworkStatus.ReadOnly] =
      AwsError.unwrapOptionField(
        "currentNetworkingStatus",
        currentNetworkingStatus
      )
    def getCurrentSoftware: ZIO[Any, AwsError, CurrentSoftware] =
      AwsError.unwrapOptionField("currentSoftware", currentSoftware)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceAggregatedStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.DeviceAggregatedStatus] =
      AwsError.unwrapOptionField(
        "deviceAggregatedStatus",
        deviceAggregatedStatus
      )
    def getDeviceConnectionStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.DeviceConnectionStatus] =
      AwsError.unwrapOptionField(
        "deviceConnectionStatus",
        deviceConnectionStatus
      )
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getLatestAlternateSoftware
        : ZIO[Any, AwsError, LatestAlternateSoftware] = AwsError
      .unwrapOptionField("latestAlternateSoftware", latestAlternateSoftware)
    def getLatestDeviceJob
        : ZIO[Any, AwsError, zio.aws.panorama.model.LatestDeviceJob.ReadOnly] =
      AwsError.unwrapOptionField("latestDeviceJob", latestDeviceJob)
    def getLatestSoftware: ZIO[Any, AwsError, LatestSoftware] =
      AwsError.unwrapOptionField("latestSoftware", latestSoftware)
    def getLeaseExpirationTime: ZIO[Any, AwsError, LeaseExpirationTime] =
      AwsError.unwrapOptionField("leaseExpirationTime", leaseExpirationTime)
    def getName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getNetworkingConfiguration
        : ZIO[Any, AwsError, zio.aws.panorama.model.NetworkPayload.ReadOnly] =
      AwsError.unwrapOptionField(
        "networkingConfiguration",
        networkingConfiguration
      )
    def getProvisioningStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.DeviceStatus] =
      AwsError.unwrapOptionField("provisioningStatus", provisioningStatus)
    def getSerialNumber: ZIO[Any, AwsError, DeviceSerialNumber] =
      AwsError.unwrapOptionField("serialNumber", serialNumber)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.panorama.model.DeviceType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse
  ) extends zio.aws.panorama.model.DescribeDeviceResponse.ReadOnly {
    override val alternateSoftwares: Optional[
      List[zio.aws.panorama.model.AlternateSoftwareMetadata.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.alternateSoftwares())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.panorama.model.AlternateSoftwareMetadata.wrap(item)
        }.toList
      )
    override val arn: Optional[DeviceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value => zio.aws.panorama.model.primitives.DeviceArn(value))
    override val brand: Optional[zio.aws.panorama.model.DeviceBrand] =
      zio.aws.core.internal
        .optionalFromNullable(impl.brand())
        .map(value => zio.aws.panorama.model.DeviceBrand.wrap(value))
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.panorama.model.primitives.CreatedTime(value))
    override val currentNetworkingStatus
        : Optional[zio.aws.panorama.model.NetworkStatus.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentNetworkingStatus())
        .map(value => zio.aws.panorama.model.NetworkStatus.wrap(value))
    override val currentSoftware: Optional[CurrentSoftware] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentSoftware())
        .map(value => zio.aws.panorama.model.primitives.CurrentSoftware(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val deviceAggregatedStatus
        : Optional[zio.aws.panorama.model.DeviceAggregatedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceAggregatedStatus())
        .map(value => zio.aws.panorama.model.DeviceAggregatedStatus.wrap(value))
    override val deviceConnectionStatus
        : Optional[zio.aws.panorama.model.DeviceConnectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceConnectionStatus())
        .map(value => zio.aws.panorama.model.DeviceConnectionStatus.wrap(value))
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
    override val latestAlternateSoftware: Optional[LatestAlternateSoftware] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestAlternateSoftware())
        .map(value =>
          zio.aws.panorama.model.primitives.LatestAlternateSoftware(value)
        )
    override val latestDeviceJob
        : Optional[zio.aws.panorama.model.LatestDeviceJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestDeviceJob())
        .map(value => zio.aws.panorama.model.LatestDeviceJob.wrap(value))
    override val latestSoftware: Optional[LatestSoftware] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestSoftware())
        .map(value => zio.aws.panorama.model.primitives.LatestSoftware(value))
    override val leaseExpirationTime: Optional[LeaseExpirationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.leaseExpirationTime())
        .map(value =>
          zio.aws.panorama.model.primitives.LeaseExpirationTime(value)
        )
    override val name: Optional[DeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.panorama.model.primitives.DeviceName(value))
    override val networkingConfiguration
        : Optional[zio.aws.panorama.model.NetworkPayload.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.networkingConfiguration())
        .map(value => zio.aws.panorama.model.NetworkPayload.wrap(value))
    override val provisioningStatus
        : Optional[zio.aws.panorama.model.DeviceStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningStatus())
      .map(value => zio.aws.panorama.model.DeviceStatus.wrap(value))
    override val serialNumber: Optional[DeviceSerialNumber] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serialNumber())
        .map(value =>
          zio.aws.panorama.model.primitives.DeviceSerialNumber(value)
        )
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.panorama.model.primitives
              .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.panorama.model.DeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.panorama.model.DeviceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeDeviceResponse
  ): zio.aws.panorama.model.DescribeDeviceResponse.ReadOnly = new Wrapper(impl)
}
