package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeNodeFromTemplateJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest = {
    import DescribeNodeFromTemplateJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest.ReadOnly =
    zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest
      .wrap(buildAwsValue())
}
object DescribeNodeFromTemplateJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest =
      zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest
  ) extends zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.panorama.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobRequest
  ): zio.aws.panorama.model.DescribeNodeFromTemplateJobRequest.ReadOnly =
    new Wrapper(impl)
}
