package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  TemplateKey,
  NodePackageName,
  NodeFromTemplateJobStatusMessage,
  NodePackageVersion,
  Description,
  NodeName,
  TemplateValue,
  JobId,
  LastUpdatedTime,
  CreatedTime
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeNodeFromTemplateJobResponse(
    createdTime: CreatedTime,
    jobId: JobId,
    jobTags: Optional[Iterable[zio.aws.panorama.model.JobResourceTags]] =
      Optional.Absent,
    lastUpdatedTime: LastUpdatedTime,
    nodeDescription: Optional[Description] = Optional.Absent,
    nodeName: NodeName,
    outputPackageName: NodePackageName,
    outputPackageVersion: NodePackageVersion,
    status: zio.aws.panorama.model.NodeFromTemplateJobStatus,
    statusMessage: NodeFromTemplateJobStatusMessage,
    templateParameters: Map[TemplateKey, TemplateValue],
    templateType: zio.aws.panorama.model.TemplateType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse = {
    import DescribeNodeFromTemplateJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse
      .builder()
      .createdTime(CreatedTime.unwrap(createdTime): Instant)
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        jobTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobTags)
      .lastUpdatedTime(LastUpdatedTime.unwrap(lastUpdatedTime): Instant)
      .optionallyWith(
        nodeDescription.map(value =>
          Description.unwrap(value): java.lang.String
        )
      )(_.nodeDescription)
      .nodeName(NodeName.unwrap(nodeName): java.lang.String)
      .outputPackageName(
        NodePackageName.unwrap(outputPackageName): java.lang.String
      )
      .outputPackageVersion(
        NodePackageVersion.unwrap(outputPackageVersion): java.lang.String
      )
      .status(status.unwrap)
      .statusMessage(
        NodeFromTemplateJobStatusMessage.unwrap(statusMessage): java.lang.String
      )
      .templateParameters(
        templateParameters
          .map({ case (key, value) =>
            (TemplateKey.unwrap(key): java.lang.String) -> (TemplateValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .templateType(templateType.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.ReadOnly =
    zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse
      .wrap(buildAwsValue())
}
object DescribeNodeFromTemplateJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse =
      zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse(
        createdTime,
        jobId,
        jobTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lastUpdatedTime,
        nodeDescription.map(value => value),
        nodeName,
        outputPackageName,
        outputPackageVersion,
        status,
        statusMessage,
        templateParameters,
        templateType
      )
    def createdTime: CreatedTime
    def jobId: JobId
    def jobTags: Optional[List[zio.aws.panorama.model.JobResourceTags.ReadOnly]]
    def lastUpdatedTime: LastUpdatedTime
    def nodeDescription: Optional[Description]
    def nodeName: NodeName
    def outputPackageName: NodePackageName
    def outputPackageVersion: NodePackageVersion
    def status: zio.aws.panorama.model.NodeFromTemplateJobStatus
    def statusMessage: NodeFromTemplateJobStatusMessage
    def templateParameters: Map[TemplateKey, TemplateValue]
    def templateType: zio.aws.panorama.model.TemplateType
    def getCreatedTime: ZIO[Any, Nothing, CreatedTime] =
      ZIO.succeed(createdTime)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getJobTags: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.JobResourceTags.ReadOnly
    ]] = AwsError.unwrapOptionField("jobTags", jobTags)
    def getLastUpdatedTime: ZIO[Any, Nothing, LastUpdatedTime] =
      ZIO.succeed(lastUpdatedTime)
    def getNodeDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("nodeDescription", nodeDescription)
    def getNodeName: ZIO[Any, Nothing, NodeName] = ZIO.succeed(nodeName)
    def getOutputPackageName: ZIO[Any, Nothing, NodePackageName] =
      ZIO.succeed(outputPackageName)
    def getOutputPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(outputPackageVersion)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.panorama.model.NodeFromTemplateJobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, Nothing, NodeFromTemplateJobStatusMessage] =
      ZIO.succeed(statusMessage)
    def getTemplateParameters
        : ZIO[Any, Nothing, Map[TemplateKey, TemplateValue]] =
      ZIO.succeed(templateParameters)
    def getTemplateType
        : ZIO[Any, Nothing, zio.aws.panorama.model.TemplateType] =
      ZIO.succeed(templateType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse
  ) extends zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.ReadOnly {
    override val createdTime: CreatedTime =
      zio.aws.panorama.model.primitives.CreatedTime(impl.createdTime())
    override val jobId: JobId =
      zio.aws.panorama.model.primitives.JobId(impl.jobId())
    override val jobTags
        : Optional[List[zio.aws.panorama.model.JobResourceTags.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.JobResourceTags.wrap(item)
          }.toList
        )
    override val lastUpdatedTime: LastUpdatedTime =
      zio.aws.panorama.model.primitives.LastUpdatedTime(impl.lastUpdatedTime())
    override val nodeDescription: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.nodeDescription())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val nodeName: NodeName =
      zio.aws.panorama.model.primitives.NodeName(impl.nodeName())
    override val outputPackageName: NodePackageName =
      zio.aws.panorama.model.primitives
        .NodePackageName(impl.outputPackageName())
    override val outputPackageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.outputPackageVersion())
    override val status: zio.aws.panorama.model.NodeFromTemplateJobStatus =
      zio.aws.panorama.model.NodeFromTemplateJobStatus.wrap(impl.status())
    override val statusMessage: NodeFromTemplateJobStatusMessage =
      zio.aws.panorama.model.primitives
        .NodeFromTemplateJobStatusMessage(impl.statusMessage())
    override val templateParameters: Map[TemplateKey, TemplateValue] = impl
      .templateParameters()
      .asScala
      .map({ case (key, value) =>
        zio.aws.panorama.model.primitives.TemplateKey(
          key
        ) -> zio.aws.panorama.model.primitives.TemplateValue(value)
      })
      .toMap
    override val templateType: zio.aws.panorama.model.TemplateType =
      zio.aws.panorama.model.TemplateType.wrap(impl.templateType())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeNodeFromTemplateJobResponse
  ): zio.aws.panorama.model.DescribeNodeFromTemplateJobResponse.ReadOnly =
    new Wrapper(impl)
}
