package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{PackageOwnerAccount, NodeId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeNodeRequest(
    nodeId: NodeId,
    ownerAccount: Optional[PackageOwnerAccount] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeNodeRequest = {
    import DescribeNodeRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeNodeRequest
      .builder()
      .nodeId(NodeId.unwrap(nodeId): java.lang.String)
      .optionallyWith(
        ownerAccount.map(value =>
          PackageOwnerAccount.unwrap(value): java.lang.String
        )
      )(_.ownerAccount)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DescribeNodeRequest.ReadOnly =
    zio.aws.panorama.model.DescribeNodeRequest.wrap(buildAwsValue())
}
object DescribeNodeRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeNodeRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeNodeRequest =
      zio.aws.panorama.model
        .DescribeNodeRequest(nodeId, ownerAccount.map(value => value))
    def nodeId: NodeId
    def ownerAccount: Optional[PackageOwnerAccount]
    def getNodeId: ZIO[Any, Nothing, NodeId] = ZIO.succeed(nodeId)
    def getOwnerAccount: ZIO[Any, AwsError, PackageOwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeNodeRequest
  ) extends zio.aws.panorama.model.DescribeNodeRequest.ReadOnly {
    override val nodeId: NodeId =
      zio.aws.panorama.model.primitives.NodeId(impl.nodeId())
    override val ownerAccount: Optional[PackageOwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAccount())
        .map(value =>
          zio.aws.panorama.model.primitives.PackageOwnerAccount(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeNodeRequest
  ): zio.aws.panorama.model.DescribeNodeRequest.ReadOnly = new Wrapper(impl)
}
