package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  NodePackageName,
  NodePackageId,
  NodeAssetName,
  NodePackageArn,
  NodePackageVersion,
  Description,
  NodeName,
  PackageOwnerAccount,
  TimeStamp,
  NodePackagePatchVersion,
  NodeId
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeNodeResponse(
    assetName: Optional[NodeAssetName] = Optional.Absent,
    category: zio.aws.panorama.model.NodeCategory,
    createdTime: TimeStamp,
    description: Description,
    lastUpdatedTime: TimeStamp,
    name: NodeName,
    nodeId: NodeId,
    nodeInterface: zio.aws.panorama.model.NodeInterface,
    ownerAccount: PackageOwnerAccount,
    packageArn: Optional[NodePackageArn] = Optional.Absent,
    packageId: NodePackageId,
    packageName: NodePackageName,
    packageVersion: NodePackageVersion,
    patchVersion: NodePackagePatchVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribeNodeResponse = {
    import DescribeNodeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribeNodeResponse
      .builder()
      .optionallyWith(
        assetName.map(value => NodeAssetName.unwrap(value): java.lang.String)
      )(_.assetName)
      .category(category.unwrap)
      .createdTime(TimeStamp.unwrap(createdTime): Instant)
      .description(Description.unwrap(description): java.lang.String)
      .lastUpdatedTime(TimeStamp.unwrap(lastUpdatedTime): Instant)
      .name(NodeName.unwrap(name): java.lang.String)
      .nodeId(NodeId.unwrap(nodeId): java.lang.String)
      .nodeInterface(nodeInterface.buildAwsValue())
      .ownerAccount(PackageOwnerAccount.unwrap(ownerAccount): java.lang.String)
      .optionallyWith(
        packageArn.map(value => NodePackageArn.unwrap(value): java.lang.String)
      )(_.packageArn)
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .packageName(NodePackageName.unwrap(packageName): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .patchVersion(
        NodePackagePatchVersion.unwrap(patchVersion): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DescribeNodeResponse.ReadOnly =
    zio.aws.panorama.model.DescribeNodeResponse.wrap(buildAwsValue())
}
object DescribeNodeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribeNodeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribeNodeResponse =
      zio.aws.panorama.model.DescribeNodeResponse(
        assetName.map(value => value),
        category,
        createdTime,
        description,
        lastUpdatedTime,
        name,
        nodeId,
        nodeInterface.asEditable,
        ownerAccount,
        packageArn.map(value => value),
        packageId,
        packageName,
        packageVersion,
        patchVersion
      )
    def assetName: Optional[NodeAssetName]
    def category: zio.aws.panorama.model.NodeCategory
    def createdTime: TimeStamp
    def description: Description
    def lastUpdatedTime: TimeStamp
    def name: NodeName
    def nodeId: NodeId
    def nodeInterface: zio.aws.panorama.model.NodeInterface.ReadOnly
    def ownerAccount: PackageOwnerAccount
    def packageArn: Optional[NodePackageArn]
    def packageId: NodePackageId
    def packageName: NodePackageName
    def packageVersion: NodePackageVersion
    def patchVersion: NodePackagePatchVersion
    def getAssetName: ZIO[Any, AwsError, NodeAssetName] =
      AwsError.unwrapOptionField("assetName", assetName)
    def getCategory: ZIO[Any, Nothing, zio.aws.panorama.model.NodeCategory] =
      ZIO.succeed(category)
    def getCreatedTime: ZIO[Any, Nothing, TimeStamp] = ZIO.succeed(createdTime)
    def getDescription: ZIO[Any, Nothing, Description] =
      ZIO.succeed(description)
    def getLastUpdatedTime: ZIO[Any, Nothing, TimeStamp] =
      ZIO.succeed(lastUpdatedTime)
    def getName: ZIO[Any, Nothing, NodeName] = ZIO.succeed(name)
    def getNodeId: ZIO[Any, Nothing, NodeId] = ZIO.succeed(nodeId)
    def getNodeInterface
        : ZIO[Any, Nothing, zio.aws.panorama.model.NodeInterface.ReadOnly] =
      ZIO.succeed(nodeInterface)
    def getOwnerAccount: ZIO[Any, Nothing, PackageOwnerAccount] =
      ZIO.succeed(ownerAccount)
    def getPackageArn: ZIO[Any, AwsError, NodePackageArn] =
      AwsError.unwrapOptionField("packageArn", packageArn)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
    def getPackageName: ZIO[Any, Nothing, NodePackageName] =
      ZIO.succeed(packageName)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
    def getPatchVersion: ZIO[Any, Nothing, NodePackagePatchVersion] =
      ZIO.succeed(patchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribeNodeResponse
  ) extends zio.aws.panorama.model.DescribeNodeResponse.ReadOnly {
    override val assetName: Optional[NodeAssetName] = zio.aws.core.internal
      .optionalFromNullable(impl.assetName())
      .map(value => zio.aws.panorama.model.primitives.NodeAssetName(value))
    override val category: zio.aws.panorama.model.NodeCategory =
      zio.aws.panorama.model.NodeCategory.wrap(impl.category())
    override val createdTime: TimeStamp =
      zio.aws.panorama.model.primitives.TimeStamp(impl.createdTime())
    override val description: Description =
      zio.aws.panorama.model.primitives.Description(impl.description())
    override val lastUpdatedTime: TimeStamp =
      zio.aws.panorama.model.primitives.TimeStamp(impl.lastUpdatedTime())
    override val name: NodeName =
      zio.aws.panorama.model.primitives.NodeName(impl.name())
    override val nodeId: NodeId =
      zio.aws.panorama.model.primitives.NodeId(impl.nodeId())
    override val nodeInterface: zio.aws.panorama.model.NodeInterface.ReadOnly =
      zio.aws.panorama.model.NodeInterface.wrap(impl.nodeInterface())
    override val ownerAccount: PackageOwnerAccount =
      zio.aws.panorama.model.primitives.PackageOwnerAccount(impl.ownerAccount())
    override val packageArn: Optional[NodePackageArn] = zio.aws.core.internal
      .optionalFromNullable(impl.packageArn())
      .map(value => zio.aws.panorama.model.primitives.NodePackageArn(value))
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
    override val packageName: NodePackageName =
      zio.aws.panorama.model.primitives.NodePackageName(impl.packageName())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
    override val patchVersion: NodePackagePatchVersion =
      zio.aws.panorama.model.primitives
        .NodePackagePatchVersion(impl.patchVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribeNodeResponse
  ): zio.aws.panorama.model.DescribeNodeResponse.ReadOnly = new Wrapper(impl)
}
