package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.JobId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribePackageImportJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest = {
    import DescribePackageImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribePackageImportJobRequest.ReadOnly =
    zio.aws.panorama.model.DescribePackageImportJobRequest.wrap(buildAwsValue())
}
object DescribePackageImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribePackageImportJobRequest =
      zio.aws.panorama.model.DescribePackageImportJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest
  ) extends zio.aws.panorama.model.DescribePackageImportJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.panorama.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageImportJobRequest
  ): zio.aws.panorama.model.DescribePackageImportJobRequest.ReadOnly =
    new Wrapper(impl)
}
