package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  PackageImportJobStatusMessage,
  JobId,
  ClientToken,
  LastUpdatedTime,
  CreatedTime
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribePackageImportJobResponse(
    clientToken: Optional[ClientToken] = Optional.Absent,
    createdTime: CreatedTime,
    inputConfig: zio.aws.panorama.model.PackageImportJobInputConfig,
    jobId: JobId,
    jobTags: Optional[Iterable[zio.aws.panorama.model.JobResourceTags]] =
      Optional.Absent,
    jobType: zio.aws.panorama.model.PackageImportJobType,
    lastUpdatedTime: LastUpdatedTime,
    output: zio.aws.panorama.model.PackageImportJobOutput,
    outputConfig: zio.aws.panorama.model.PackageImportJobOutputConfig,
    status: zio.aws.panorama.model.PackageImportJobStatus,
    statusMessage: PackageImportJobStatusMessage
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse = {
    import DescribePackageImportJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse
      .builder()
      .optionallyWith(
        clientToken.map(value => ClientToken.unwrap(value): java.lang.String)
      )(_.clientToken)
      .createdTime(CreatedTime.unwrap(createdTime): Instant)
      .inputConfig(inputConfig.buildAwsValue())
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .optionallyWith(
        jobTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.jobTags)
      .jobType(jobType.unwrap)
      .lastUpdatedTime(LastUpdatedTime.unwrap(lastUpdatedTime): Instant)
      .output(output.buildAwsValue())
      .outputConfig(outputConfig.buildAwsValue())
      .status(status.unwrap)
      .statusMessage(
        PackageImportJobStatusMessage.unwrap(statusMessage): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribePackageImportJobResponse.ReadOnly =
    zio.aws.panorama.model.DescribePackageImportJobResponse
      .wrap(buildAwsValue())
}
object DescribePackageImportJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribePackageImportJobResponse =
      zio.aws.panorama.model.DescribePackageImportJobResponse(
        clientToken.map(value => value),
        createdTime,
        inputConfig.asEditable,
        jobId,
        jobTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        jobType,
        lastUpdatedTime,
        output.asEditable,
        outputConfig.asEditable,
        status,
        statusMessage
      )
    def clientToken: Optional[ClientToken]
    def createdTime: CreatedTime
    def inputConfig: zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly
    def jobId: JobId
    def jobTags: Optional[List[zio.aws.panorama.model.JobResourceTags.ReadOnly]]
    def jobType: zio.aws.panorama.model.PackageImportJobType
    def lastUpdatedTime: LastUpdatedTime
    def output: zio.aws.panorama.model.PackageImportJobOutput.ReadOnly
    def outputConfig
        : zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly
    def status: zio.aws.panorama.model.PackageImportJobStatus
    def statusMessage: PackageImportJobStatusMessage
    def getClientToken: ZIO[Any, AwsError, ClientToken] =
      AwsError.unwrapOptionField("clientToken", clientToken)
    def getCreatedTime: ZIO[Any, Nothing, CreatedTime] =
      ZIO.succeed(createdTime)
    def getInputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly
    ] = ZIO.succeed(inputConfig)
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
    def getJobTags: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.JobResourceTags.ReadOnly
    ]] = AwsError.unwrapOptionField("jobTags", jobTags)
    def getJobType
        : ZIO[Any, Nothing, zio.aws.panorama.model.PackageImportJobType] =
      ZIO.succeed(jobType)
    def getLastUpdatedTime: ZIO[Any, Nothing, LastUpdatedTime] =
      ZIO.succeed(lastUpdatedTime)
    def getOutput: ZIO[
      Any,
      Nothing,
      zio.aws.panorama.model.PackageImportJobOutput.ReadOnly
    ] = ZIO.succeed(output)
    def getOutputConfig: ZIO[
      Any,
      Nothing,
      zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly
    ] = ZIO.succeed(outputConfig)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.panorama.model.PackageImportJobStatus] =
      ZIO.succeed(status)
    def getStatusMessage: ZIO[Any, Nothing, PackageImportJobStatusMessage] =
      ZIO.succeed(statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse
  ) extends zio.aws.panorama.model.DescribePackageImportJobResponse.ReadOnly {
    override val clientToken: Optional[ClientToken] = zio.aws.core.internal
      .optionalFromNullable(impl.clientToken())
      .map(value => zio.aws.panorama.model.primitives.ClientToken(value))
    override val createdTime: CreatedTime =
      zio.aws.panorama.model.primitives.CreatedTime(impl.createdTime())
    override val inputConfig
        : zio.aws.panorama.model.PackageImportJobInputConfig.ReadOnly =
      zio.aws.panorama.model.PackageImportJobInputConfig
        .wrap(impl.inputConfig())
    override val jobId: JobId =
      zio.aws.panorama.model.primitives.JobId(impl.jobId())
    override val jobTags
        : Optional[List[zio.aws.panorama.model.JobResourceTags.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.JobResourceTags.wrap(item)
          }.toList
        )
    override val jobType: zio.aws.panorama.model.PackageImportJobType =
      zio.aws.panorama.model.PackageImportJobType.wrap(impl.jobType())
    override val lastUpdatedTime: LastUpdatedTime =
      zio.aws.panorama.model.primitives.LastUpdatedTime(impl.lastUpdatedTime())
    override val output
        : zio.aws.panorama.model.PackageImportJobOutput.ReadOnly =
      zio.aws.panorama.model.PackageImportJobOutput.wrap(impl.output())
    override val outputConfig
        : zio.aws.panorama.model.PackageImportJobOutputConfig.ReadOnly =
      zio.aws.panorama.model.PackageImportJobOutputConfig
        .wrap(impl.outputConfig())
    override val status: zio.aws.panorama.model.PackageImportJobStatus =
      zio.aws.panorama.model.PackageImportJobStatus.wrap(impl.status())
    override val statusMessage: PackageImportJobStatusMessage =
      zio.aws.panorama.model.primitives
        .PackageImportJobStatusMessage(impl.statusMessage())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageImportJobResponse
  ): zio.aws.panorama.model.DescribePackageImportJobResponse.ReadOnly =
    new Wrapper(impl)
}
