package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NodePackageId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribePackageRequest(packageId: NodePackageId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribePackageRequest = {
    import DescribePackageRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribePackageRequest
      .builder()
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DescribePackageRequest.ReadOnly =
    zio.aws.panorama.model.DescribePackageRequest.wrap(buildAwsValue())
}
object DescribePackageRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribePackageRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribePackageRequest =
      zio.aws.panorama.model.DescribePackageRequest(packageId)
    def packageId: NodePackageId
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageRequest
  ) extends zio.aws.panorama.model.DescribePackageRequest.ReadOnly {
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageRequest
  ): zio.aws.panorama.model.DescribePackageRequest.ReadOnly = new Wrapper(impl)
}
