package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  NodePackageName,
  NodePackageId,
  NodePackageArn,
  PrincipalArn,
  TagValue,
  TimeStamp,
  TagKey
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribePackageResponse(
    arn: NodePackageArn,
    createdTime: TimeStamp,
    packageId: NodePackageId,
    packageName: NodePackageName,
    readAccessPrincipalArns: Optional[Iterable[PrincipalArn]] = Optional.Absent,
    storageLocation: zio.aws.panorama.model.StorageLocation,
    tags: Map[TagKey, TagValue],
    writeAccessPrincipalArns: Optional[Iterable[PrincipalArn]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribePackageResponse = {
    import DescribePackageResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribePackageResponse
      .builder()
      .arn(NodePackageArn.unwrap(arn): java.lang.String)
      .createdTime(TimeStamp.unwrap(createdTime): Instant)
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .packageName(NodePackageName.unwrap(packageName): java.lang.String)
      .optionallyWith(
        readAccessPrincipalArns.map(value =>
          value.map { item =>
            PrincipalArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.readAccessPrincipalArns)
      .storageLocation(storageLocation.buildAwsValue())
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .optionallyWith(
        writeAccessPrincipalArns.map(value =>
          value.map { item =>
            PrincipalArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.writeAccessPrincipalArns)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DescribePackageResponse.ReadOnly =
    zio.aws.panorama.model.DescribePackageResponse.wrap(buildAwsValue())
}
object DescribePackageResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribePackageResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribePackageResponse =
      zio.aws.panorama.model.DescribePackageResponse(
        arn,
        createdTime,
        packageId,
        packageName,
        readAccessPrincipalArns.map(value => value),
        storageLocation.asEditable,
        tags,
        writeAccessPrincipalArns.map(value => value)
      )
    def arn: NodePackageArn
    def createdTime: TimeStamp
    def packageId: NodePackageId
    def packageName: NodePackageName
    def readAccessPrincipalArns: Optional[List[PrincipalArn]]
    def storageLocation: zio.aws.panorama.model.StorageLocation.ReadOnly
    def tags: Map[TagKey, TagValue]
    def writeAccessPrincipalArns: Optional[List[PrincipalArn]]
    def getArn: ZIO[Any, Nothing, NodePackageArn] = ZIO.succeed(arn)
    def getCreatedTime: ZIO[Any, Nothing, TimeStamp] = ZIO.succeed(createdTime)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
    def getPackageName: ZIO[Any, Nothing, NodePackageName] =
      ZIO.succeed(packageName)
    def getReadAccessPrincipalArns: ZIO[Any, AwsError, List[PrincipalArn]] =
      AwsError.unwrapOptionField(
        "readAccessPrincipalArns",
        readAccessPrincipalArns
      )
    def getStorageLocation
        : ZIO[Any, Nothing, zio.aws.panorama.model.StorageLocation.ReadOnly] =
      ZIO.succeed(storageLocation)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
    def getWriteAccessPrincipalArns: ZIO[Any, AwsError, List[PrincipalArn]] =
      AwsError.unwrapOptionField(
        "writeAccessPrincipalArns",
        writeAccessPrincipalArns
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageResponse
  ) extends zio.aws.panorama.model.DescribePackageResponse.ReadOnly {
    override val arn: NodePackageArn =
      zio.aws.panorama.model.primitives.NodePackageArn(impl.arn())
    override val createdTime: TimeStamp =
      zio.aws.panorama.model.primitives.TimeStamp(impl.createdTime())
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
    override val packageName: NodePackageName =
      zio.aws.panorama.model.primitives.NodePackageName(impl.packageName())
    override val readAccessPrincipalArns: Optional[List[PrincipalArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.readAccessPrincipalArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.primitives.PrincipalArn(item)
          }.toList
        )
    override val storageLocation
        : zio.aws.panorama.model.StorageLocation.ReadOnly =
      zio.aws.panorama.model.StorageLocation.wrap(impl.storageLocation())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.panorama.model.primitives
          .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
      })
      .toMap
    override val writeAccessPrincipalArns: Optional[List[PrincipalArn]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.writeAccessPrincipalArns())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.primitives.PrincipalArn(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageResponse
  ): zio.aws.panorama.model.DescribePackageResponse.ReadOnly = new Wrapper(impl)
}
