package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{
  NodePackagePatchVersion,
  NodePackageVersion,
  NodePackageId,
  PackageOwnerAccount
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribePackageVersionRequest(
    ownerAccount: Optional[PackageOwnerAccount] = Optional.Absent,
    packageId: NodePackageId,
    packageVersion: NodePackageVersion,
    patchVersion: Optional[NodePackagePatchVersion] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest = {
    import DescribePackageVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest
      .builder()
      .optionallyWith(
        ownerAccount.map(value =>
          PackageOwnerAccount.unwrap(value): java.lang.String
        )
      )(_.ownerAccount)
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .optionallyWith(
        patchVersion.map(value =>
          NodePackagePatchVersion.unwrap(value): java.lang.String
        )
      )(_.patchVersion)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribePackageVersionRequest.ReadOnly =
    zio.aws.panorama.model.DescribePackageVersionRequest.wrap(buildAwsValue())
}
object DescribePackageVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribePackageVersionRequest =
      zio.aws.panorama.model.DescribePackageVersionRequest(
        ownerAccount.map(value => value),
        packageId,
        packageVersion,
        patchVersion.map(value => value)
      )
    def ownerAccount: Optional[PackageOwnerAccount]
    def packageId: NodePackageId
    def packageVersion: NodePackageVersion
    def patchVersion: Optional[NodePackagePatchVersion]
    def getOwnerAccount: ZIO[Any, AwsError, PackageOwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
    def getPatchVersion: ZIO[Any, AwsError, NodePackagePatchVersion] =
      AwsError.unwrapOptionField("patchVersion", patchVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest
  ) extends zio.aws.panorama.model.DescribePackageVersionRequest.ReadOnly {
    override val ownerAccount: Optional[PackageOwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAccount())
        .map(value =>
          zio.aws.panorama.model.primitives.PackageOwnerAccount(value)
        )
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
    override val patchVersion: Optional[NodePackagePatchVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.patchVersion())
        .map(value =>
          zio.aws.panorama.model.primitives.NodePackagePatchVersion(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageVersionRequest
  ): zio.aws.panorama.model.DescribePackageVersionRequest.ReadOnly =
    new Wrapper(impl)
}
