package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  NodePackageName,
  NodePackageId,
  NodePackageArn,
  NodePackageVersion,
  PackageVersionStatusDescription,
  PackageOwnerAccount,
  TimeStamp,
  NodePackagePatchVersion
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribePackageVersionResponse(
    isLatestPatch: Boolean,
    ownerAccount: Optional[PackageOwnerAccount] = Optional.Absent,
    packageArn: Optional[NodePackageArn] = Optional.Absent,
    packageId: NodePackageId,
    packageName: NodePackageName,
    packageVersion: NodePackageVersion,
    patchVersion: NodePackagePatchVersion,
    registeredTime: Optional[TimeStamp] = Optional.Absent,
    status: zio.aws.panorama.model.PackageVersionStatus,
    statusDescription: Optional[PackageVersionStatusDescription] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse = {
    import DescribePackageVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse
      .builder()
      .isLatestPatch(isLatestPatch: java.lang.Boolean)
      .optionallyWith(
        ownerAccount.map(value =>
          PackageOwnerAccount.unwrap(value): java.lang.String
        )
      )(_.ownerAccount)
      .optionallyWith(
        packageArn.map(value => NodePackageArn.unwrap(value): java.lang.String)
      )(_.packageArn)
      .packageId(NodePackageId.unwrap(packageId): java.lang.String)
      .packageName(NodePackageName.unwrap(packageName): java.lang.String)
      .packageVersion(
        NodePackageVersion.unwrap(packageVersion): java.lang.String
      )
      .patchVersion(
        NodePackagePatchVersion.unwrap(patchVersion): java.lang.String
      )
      .optionallyWith(
        registeredTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.registeredTime)
      .status(status.unwrap)
      .optionallyWith(
        statusDescription.map(value =>
          PackageVersionStatusDescription.unwrap(value): java.lang.String
        )
      )(_.statusDescription)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.DescribePackageVersionResponse.ReadOnly =
    zio.aws.panorama.model.DescribePackageVersionResponse.wrap(buildAwsValue())
}
object DescribePackageVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DescribePackageVersionResponse =
      zio.aws.panorama.model.DescribePackageVersionResponse(
        isLatestPatch,
        ownerAccount.map(value => value),
        packageArn.map(value => value),
        packageId,
        packageName,
        packageVersion,
        patchVersion,
        registeredTime.map(value => value),
        status,
        statusDescription.map(value => value)
      )
    def isLatestPatch: Boolean
    def ownerAccount: Optional[PackageOwnerAccount]
    def packageArn: Optional[NodePackageArn]
    def packageId: NodePackageId
    def packageName: NodePackageName
    def packageVersion: NodePackageVersion
    def patchVersion: NodePackagePatchVersion
    def registeredTime: Optional[TimeStamp]
    def status: zio.aws.panorama.model.PackageVersionStatus
    def statusDescription: Optional[PackageVersionStatusDescription]
    def getIsLatestPatch: ZIO[Any, Nothing, Boolean] =
      ZIO.succeed(isLatestPatch)
    def getOwnerAccount: ZIO[Any, AwsError, PackageOwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getPackageArn: ZIO[Any, AwsError, NodePackageArn] =
      AwsError.unwrapOptionField("packageArn", packageArn)
    def getPackageId: ZIO[Any, Nothing, NodePackageId] = ZIO.succeed(packageId)
    def getPackageName: ZIO[Any, Nothing, NodePackageName] =
      ZIO.succeed(packageName)
    def getPackageVersion: ZIO[Any, Nothing, NodePackageVersion] =
      ZIO.succeed(packageVersion)
    def getPatchVersion: ZIO[Any, Nothing, NodePackagePatchVersion] =
      ZIO.succeed(patchVersion)
    def getRegisteredTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("registeredTime", registeredTime)
    def getStatus
        : ZIO[Any, Nothing, zio.aws.panorama.model.PackageVersionStatus] =
      ZIO.succeed(status)
    def getStatusDescription
        : ZIO[Any, AwsError, PackageVersionStatusDescription] =
      AwsError.unwrapOptionField("statusDescription", statusDescription)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse
  ) extends zio.aws.panorama.model.DescribePackageVersionResponse.ReadOnly {
    override val isLatestPatch: Boolean = impl.isLatestPatch(): Boolean
    override val ownerAccount: Optional[PackageOwnerAccount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ownerAccount())
        .map(value =>
          zio.aws.panorama.model.primitives.PackageOwnerAccount(value)
        )
    override val packageArn: Optional[NodePackageArn] = zio.aws.core.internal
      .optionalFromNullable(impl.packageArn())
      .map(value => zio.aws.panorama.model.primitives.NodePackageArn(value))
    override val packageId: NodePackageId =
      zio.aws.panorama.model.primitives.NodePackageId(impl.packageId())
    override val packageName: NodePackageName =
      zio.aws.panorama.model.primitives.NodePackageName(impl.packageName())
    override val packageVersion: NodePackageVersion =
      zio.aws.panorama.model.primitives
        .NodePackageVersion(impl.packageVersion())
    override val patchVersion: NodePackagePatchVersion =
      zio.aws.panorama.model.primitives
        .NodePackagePatchVersion(impl.patchVersion())
    override val registeredTime: Optional[TimeStamp] = zio.aws.core.internal
      .optionalFromNullable(impl.registeredTime())
      .map(value => zio.aws.panorama.model.primitives.TimeStamp(value))
    override val status: zio.aws.panorama.model.PackageVersionStatus =
      zio.aws.panorama.model.PackageVersionStatus.wrap(impl.status())
    override val statusDescription: Optional[PackageVersionStatusDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusDescription())
        .map(value =>
          zio.aws.panorama.model.primitives
            .PackageVersionStatusDescription(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DescribePackageVersionResponse
  ): zio.aws.panorama.model.DescribePackageVersionResponse.ReadOnly =
    new Wrapper(impl)
}
