package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait DesiredState {
  def unwrap: software.amazon.awssdk.services.panorama.model.DesiredState
}
object DesiredState {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.DesiredState
  ): zio.aws.panorama.model.DesiredState = value match {
    case software.amazon.awssdk.services.panorama.model.DesiredState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.DesiredState.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.panorama.model.DesiredState.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.panorama.model.DesiredState.REMOVED =>
      val r = REMOVED
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.DesiredState {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DesiredState =
      software.amazon.awssdk.services.panorama.model.DesiredState.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.panorama.model.DesiredState {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DesiredState =
      software.amazon.awssdk.services.panorama.model.DesiredState.RUNNING
  }
  case object STOPPED extends zio.aws.panorama.model.DesiredState {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DesiredState =
      software.amazon.awssdk.services.panorama.model.DesiredState.STOPPED
  }
  case object REMOVED extends zio.aws.panorama.model.DesiredState {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DesiredState =
      software.amazon.awssdk.services.panorama.model.DesiredState.REMOVED
  }
}
