package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  LeaseExpirationTime,
  DeviceName,
  DeviceId,
  TagValue,
  CurrentSoftware,
  Description,
  LastUpdatedTime,
  CreatedTime,
  TagKey
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Device(
    brand: Optional[zio.aws.panorama.model.DeviceBrand] = Optional.Absent,
    createdTime: Optional[CreatedTime] = Optional.Absent,
    currentSoftware: Optional[CurrentSoftware] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    deviceAggregatedStatus: Optional[
      zio.aws.panorama.model.DeviceAggregatedStatus
    ] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    lastUpdatedTime: Optional[LastUpdatedTime] = Optional.Absent,
    latestDeviceJob: Optional[zio.aws.panorama.model.LatestDeviceJob] =
      Optional.Absent,
    leaseExpirationTime: Optional[LeaseExpirationTime] = Optional.Absent,
    name: Optional[DeviceName] = Optional.Absent,
    provisioningStatus: Optional[zio.aws.panorama.model.DeviceStatus] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    `type`: Optional[zio.aws.panorama.model.DeviceType] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.panorama.model.Device = {
    import Device.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.Device
      .builder()
      .optionallyWith(brand.map(value => value.unwrap))(_.brand)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        currentSoftware.map(value =>
          CurrentSoftware.unwrap(value): java.lang.String
        )
      )(_.currentSoftware)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(deviceAggregatedStatus.map(value => value.unwrap))(
        _.deviceAggregatedStatus
      )
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        lastUpdatedTime.map(value => LastUpdatedTime.unwrap(value): Instant)
      )(_.lastUpdatedTime)
      .optionallyWith(latestDeviceJob.map(value => value.buildAwsValue()))(
        _.latestDeviceJob
      )
      .optionallyWith(
        leaseExpirationTime.map(value =>
          LeaseExpirationTime.unwrap(value): Instant
        )
      )(_.leaseExpirationTime)
      .optionallyWith(
        name.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(provisioningStatus.map(value => value.unwrap))(
        _.provisioningStatus
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.Device.ReadOnly =
    zio.aws.panorama.model.Device.wrap(buildAwsValue())
}
object Device {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.panorama.model.Device] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.Device =
      zio.aws.panorama.model.Device(
        brand.map(value => value),
        createdTime.map(value => value),
        currentSoftware.map(value => value),
        description.map(value => value),
        deviceAggregatedStatus.map(value => value),
        deviceId.map(value => value),
        lastUpdatedTime.map(value => value),
        latestDeviceJob.map(value => value.asEditable),
        leaseExpirationTime.map(value => value),
        name.map(value => value),
        provisioningStatus.map(value => value),
        tags.map(value => value),
        `type`.map(value => value)
      )
    def brand: Optional[zio.aws.panorama.model.DeviceBrand]
    def createdTime: Optional[CreatedTime]
    def currentSoftware: Optional[CurrentSoftware]
    def description: Optional[Description]
    def deviceAggregatedStatus
        : Optional[zio.aws.panorama.model.DeviceAggregatedStatus]
    def deviceId: Optional[DeviceId]
    def lastUpdatedTime: Optional[LastUpdatedTime]
    def latestDeviceJob
        : Optional[zio.aws.panorama.model.LatestDeviceJob.ReadOnly]
    def leaseExpirationTime: Optional[LeaseExpirationTime]
    def name: Optional[DeviceName]
    def provisioningStatus: Optional[zio.aws.panorama.model.DeviceStatus]
    def tags: Optional[Map[TagKey, TagValue]]
    def `type`: Optional[zio.aws.panorama.model.DeviceType]
    def getBrand: ZIO[Any, AwsError, zio.aws.panorama.model.DeviceBrand] =
      AwsError.unwrapOptionField("brand", brand)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getCurrentSoftware: ZIO[Any, AwsError, CurrentSoftware] =
      AwsError.unwrapOptionField("currentSoftware", currentSoftware)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDeviceAggregatedStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.DeviceAggregatedStatus] =
      AwsError.unwrapOptionField(
        "deviceAggregatedStatus",
        deviceAggregatedStatus
      )
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getLastUpdatedTime: ZIO[Any, AwsError, LastUpdatedTime] =
      AwsError.unwrapOptionField("lastUpdatedTime", lastUpdatedTime)
    def getLatestDeviceJob
        : ZIO[Any, AwsError, zio.aws.panorama.model.LatestDeviceJob.ReadOnly] =
      AwsError.unwrapOptionField("latestDeviceJob", latestDeviceJob)
    def getLeaseExpirationTime: ZIO[Any, AwsError, LeaseExpirationTime] =
      AwsError.unwrapOptionField("leaseExpirationTime", leaseExpirationTime)
    def getName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("name", name)
    def getProvisioningStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.DeviceStatus] =
      AwsError.unwrapOptionField("provisioningStatus", provisioningStatus)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getType: ZIO[Any, AwsError, zio.aws.panorama.model.DeviceType] =
      AwsError.unwrapOptionField("type", `type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.Device
  ) extends zio.aws.panorama.model.Device.ReadOnly {
    override val brand: Optional[zio.aws.panorama.model.DeviceBrand] =
      zio.aws.core.internal
        .optionalFromNullable(impl.brand())
        .map(value => zio.aws.panorama.model.DeviceBrand.wrap(value))
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.panorama.model.primitives.CreatedTime(value))
    override val currentSoftware: Optional[CurrentSoftware] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentSoftware())
        .map(value => zio.aws.panorama.model.primitives.CurrentSoftware(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.panorama.model.primitives.Description(value))
    override val deviceAggregatedStatus
        : Optional[zio.aws.panorama.model.DeviceAggregatedStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deviceAggregatedStatus())
        .map(value => zio.aws.panorama.model.DeviceAggregatedStatus.wrap(value))
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
    override val lastUpdatedTime: Optional[LastUpdatedTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTime())
        .map(value => zio.aws.panorama.model.primitives.LastUpdatedTime(value))
    override val latestDeviceJob
        : Optional[zio.aws.panorama.model.LatestDeviceJob.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestDeviceJob())
        .map(value => zio.aws.panorama.model.LatestDeviceJob.wrap(value))
    override val leaseExpirationTime: Optional[LeaseExpirationTime] =
      zio.aws.core.internal
        .optionalFromNullable(impl.leaseExpirationTime())
        .map(value =>
          zio.aws.panorama.model.primitives.LeaseExpirationTime(value)
        )
    override val name: Optional[DeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.panorama.model.primitives.DeviceName(value))
    override val provisioningStatus
        : Optional[zio.aws.panorama.model.DeviceStatus] = zio.aws.core.internal
      .optionalFromNullable(impl.provisioningStatus())
      .map(value => zio.aws.panorama.model.DeviceStatus.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.panorama.model.primitives
              .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val `type`: Optional[zio.aws.panorama.model.DeviceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.panorama.model.DeviceType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.Device
  ): zio.aws.panorama.model.Device.ReadOnly = new Wrapper(impl)
}
