package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait DeviceAggregatedStatus {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus
}
object DeviceAggregatedStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus
  ): zio.aws.panorama.model.DeviceAggregatedStatus = value match {
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.AWAITING_PROVISIONING =>
      val r = AWAITING_PROVISIONING
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.ONLINE =>
      val r = ONLINE
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.OFFLINE =>
      val r = OFFLINE
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.LEASE_EXPIRED =>
      val r = LEASE_EXPIRED
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.UPDATE_NEEDED =>
      val r = UPDATE_NEEDED
      r
    case software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.REBOOTING =>
      val r = REBOOTING
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ERROR extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.ERROR
  }
  case object AWAITING_PROVISIONING
      extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.AWAITING_PROVISIONING
  }
  case object PENDING extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.PENDING
  }
  case object FAILED extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.FAILED
  }
  case object DELETING extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.DELETING
  }
  case object ONLINE extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.ONLINE
  }
  case object OFFLINE extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.OFFLINE
  }
  case object LEASE_EXPIRED
      extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.LEASE_EXPIRED
  }
  case object UPDATE_NEEDED
      extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.UPDATE_NEEDED
  }
  case object REBOOTING extends zio.aws.panorama.model.DeviceAggregatedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceAggregatedStatus.REBOOTING
  }
}
