package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait DeviceBrand {
  def unwrap: software.amazon.awssdk.services.panorama.model.DeviceBrand
}
object DeviceBrand {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.DeviceBrand
  ): zio.aws.panorama.model.DeviceBrand = value match {
    case software.amazon.awssdk.services.panorama.model.DeviceBrand.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.DeviceBrand.AWS_PANORAMA =>
      val r = AWS_PANORAMA
      r
    case software.amazon.awssdk.services.panorama.model.DeviceBrand.LENOVO =>
      val r = LENOVO
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.DeviceBrand {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceBrand =
      software.amazon.awssdk.services.panorama.model.DeviceBrand.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_PANORAMA extends zio.aws.panorama.model.DeviceBrand {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceBrand =
      software.amazon.awssdk.services.panorama.model.DeviceBrand.AWS_PANORAMA
  }
  case object LENOVO extends zio.aws.panorama.model.DeviceBrand {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceBrand =
      software.amazon.awssdk.services.panorama.model.DeviceBrand.LENOVO
  }
}
