package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait DeviceConnectionStatus {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus
}
object DeviceConnectionStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus
  ): zio.aws.panorama.model.DeviceConnectionStatus = value match {
    case software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.ONLINE =>
      val r = ONLINE
      r
    case software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.OFFLINE =>
      val r = OFFLINE
      r
    case software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.AWAITING_CREDENTIALS =>
      val r = AWAITING_CREDENTIALS
      r
    case software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.NOT_AVAILABLE =>
      val r = NOT_AVAILABLE
      r
    case software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.DeviceConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus =
      software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ONLINE extends zio.aws.panorama.model.DeviceConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus =
      software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.ONLINE
  }
  case object OFFLINE extends zio.aws.panorama.model.DeviceConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus =
      software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.OFFLINE
  }
  case object AWAITING_CREDENTIALS
      extends zio.aws.panorama.model.DeviceConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus =
      software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.AWAITING_CREDENTIALS
  }
  case object NOT_AVAILABLE
      extends zio.aws.panorama.model.DeviceConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus =
      software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.NOT_AVAILABLE
  }
  case object ERROR extends zio.aws.panorama.model.DeviceConnectionStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus =
      software.amazon.awssdk.services.panorama.model.DeviceConnectionStatus.ERROR
  }
}
