package zio.aws.panorama.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  JobId,
  DeviceName,
  DeviceId,
  CreatedTime
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DeviceJob(
    createdTime: Optional[CreatedTime] = Optional.Absent,
    deviceId: Optional[DeviceId] = Optional.Absent,
    deviceName: Optional[DeviceName] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent,
    jobType: Optional[zio.aws.panorama.model.JobType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DeviceJob = {
    import DeviceJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DeviceJob
      .builder()
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        deviceName.map(value => DeviceName.unwrap(value): java.lang.String)
      )(_.deviceName)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DeviceJob.ReadOnly =
    zio.aws.panorama.model.DeviceJob.wrap(buildAwsValue())
}
object DeviceJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DeviceJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DeviceJob =
      zio.aws.panorama.model.DeviceJob(
        createdTime.map(value => value),
        deviceId.map(value => value),
        deviceName.map(value => value),
        jobId.map(value => value),
        jobType.map(value => value)
      )
    def createdTime: Optional[CreatedTime]
    def deviceId: Optional[DeviceId]
    def deviceName: Optional[DeviceName]
    def jobId: Optional[JobId]
    def jobType: Optional[zio.aws.panorama.model.JobType]
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getDeviceName: ZIO[Any, AwsError, DeviceName] =
      AwsError.unwrapOptionField("deviceName", deviceName)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
    def getJobType: ZIO[Any, AwsError, zio.aws.panorama.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DeviceJob
  ) extends zio.aws.panorama.model.DeviceJob.ReadOnly {
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value => zio.aws.panorama.model.primitives.CreatedTime(value))
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
    override val deviceName: Optional[DeviceName] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceName())
      .map(value => zio.aws.panorama.model.primitives.DeviceName(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.panorama.model.primitives.JobId(value))
    override val jobType: Optional[zio.aws.panorama.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.panorama.model.JobType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DeviceJob
  ): zio.aws.panorama.model.DeviceJob.ReadOnly = new Wrapper(impl)
}
