package zio.aws.panorama.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeviceJobConfig(
    otaJobConfig: Optional[zio.aws.panorama.model.OTAJobConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.DeviceJobConfig = {
    import DeviceJobConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.DeviceJobConfig
      .builder()
      .optionallyWith(otaJobConfig.map(value => value.buildAwsValue()))(
        _.otaJobConfig
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.DeviceJobConfig.ReadOnly =
    zio.aws.panorama.model.DeviceJobConfig.wrap(buildAwsValue())
}
object DeviceJobConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.DeviceJobConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.DeviceJobConfig =
      zio.aws.panorama.model
        .DeviceJobConfig(otaJobConfig.map(value => value.asEditable))
    def otaJobConfig: Optional[zio.aws.panorama.model.OTAJobConfig.ReadOnly]
    def getOtaJobConfig
        : ZIO[Any, AwsError, zio.aws.panorama.model.OTAJobConfig.ReadOnly] =
      AwsError.unwrapOptionField("otaJobConfig", otaJobConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.DeviceJobConfig
  ) extends zio.aws.panorama.model.DeviceJobConfig.ReadOnly {
    override val otaJobConfig
        : Optional[zio.aws.panorama.model.OTAJobConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otaJobConfig())
        .map(value => zio.aws.panorama.model.OTAJobConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.DeviceJobConfig
  ): zio.aws.panorama.model.DeviceJobConfig.ReadOnly = new Wrapper(impl)
}
