package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait DeviceReportedStatus {
  def unwrap
      : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus
}
object DeviceReportedStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.DeviceReportedStatus
  ): zio.aws.panorama.model.DeviceReportedStatus = value match {
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.STOPPING =>
      val r = STOPPING
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.STOP_ERROR =>
      val r = STOP_ERROR
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.REMOVAL_FAILED =>
      val r = REMOVAL_FAILED
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.REMOVAL_IN_PROGRESS =>
      val r = REMOVAL_IN_PROGRESS
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.STARTING =>
      val r = STARTING
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.INSTALL_ERROR =>
      val r = INSTALL_ERROR
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.LAUNCHED =>
      val r = LAUNCHED
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.LAUNCH_ERROR =>
      val r = LAUNCH_ERROR
      r
    case software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.INSTALL_IN_PROGRESS =>
      val r = INSTALL_IN_PROGRESS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object STOPPING extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.STOPPING
  }
  case object STOPPED extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.STOPPED
  }
  case object STOP_ERROR extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.STOP_ERROR
  }
  case object REMOVAL_FAILED
      extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.REMOVAL_FAILED
  }
  case object REMOVAL_IN_PROGRESS
      extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.REMOVAL_IN_PROGRESS
  }
  case object STARTING extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.STARTING
  }
  case object RUNNING extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.RUNNING
  }
  case object INSTALL_ERROR
      extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.INSTALL_ERROR
  }
  case object LAUNCHED extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.LAUNCHED
  }
  case object LAUNCH_ERROR extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.LAUNCH_ERROR
  }
  case object INSTALL_IN_PROGRESS
      extends zio.aws.panorama.model.DeviceReportedStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceReportedStatus =
      software.amazon.awssdk.services.panorama.model.DeviceReportedStatus.INSTALL_IN_PROGRESS
  }
}
