package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait DeviceStatus {
  def unwrap: software.amazon.awssdk.services.panorama.model.DeviceStatus
}
object DeviceStatus {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.DeviceStatus
  ): zio.aws.panorama.model.DeviceStatus = value match {
    case software.amazon.awssdk.services.panorama.model.DeviceStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.DeviceStatus.AWAITING_PROVISIONING =>
      val r = AWAITING_PROVISIONING
      r
    case software.amazon.awssdk.services.panorama.model.DeviceStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.panorama.model.DeviceStatus.SUCCEEDED =>
      val r = SUCCEEDED
      r
    case software.amazon.awssdk.services.panorama.model.DeviceStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.panorama.model.DeviceStatus.ERROR =>
      val r = ERROR
      r
    case software.amazon.awssdk.services.panorama.model.DeviceStatus.DELETING =>
      val r = DELETING
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceStatus =
      software.amazon.awssdk.services.panorama.model.DeviceStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object AWAITING_PROVISIONING
      extends zio.aws.panorama.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceStatus =
      software.amazon.awssdk.services.panorama.model.DeviceStatus.AWAITING_PROVISIONING
  }
  case object PENDING extends zio.aws.panorama.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceStatus =
      software.amazon.awssdk.services.panorama.model.DeviceStatus.PENDING
  }
  case object SUCCEEDED extends zio.aws.panorama.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceStatus =
      software.amazon.awssdk.services.panorama.model.DeviceStatus.SUCCEEDED
  }
  case object FAILED extends zio.aws.panorama.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceStatus =
      software.amazon.awssdk.services.panorama.model.DeviceStatus.FAILED
  }
  case object ERROR extends zio.aws.panorama.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceStatus =
      software.amazon.awssdk.services.panorama.model.DeviceStatus.ERROR
  }
  case object DELETING extends zio.aws.panorama.model.DeviceStatus {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceStatus =
      software.amazon.awssdk.services.panorama.model.DeviceStatus.DELETING
  }
}
