package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait DeviceType {
  def unwrap: software.amazon.awssdk.services.panorama.model.DeviceType
}
object DeviceType {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.DeviceType
  ): zio.aws.panorama.model.DeviceType = value match {
    case software.amazon.awssdk.services.panorama.model.DeviceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.DeviceType.PANORAMA_APPLIANCE_DEVELOPER_KIT =>
      val r = PANORAMA_APPLIANCE_DEVELOPER_KIT
      r
    case software.amazon.awssdk.services.panorama.model.DeviceType.PANORAMA_APPLIANCE =>
      val r = PANORAMA_APPLIANCE
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.DeviceType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceType =
      software.amazon.awssdk.services.panorama.model.DeviceType.UNKNOWN_TO_SDK_VERSION
  }
  case object PANORAMA_APPLIANCE_DEVELOPER_KIT
      extends zio.aws.panorama.model.DeviceType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceType =
      software.amazon.awssdk.services.panorama.model.DeviceType.PANORAMA_APPLIANCE_DEVELOPER_KIT
  }
  case object PANORAMA_APPLIANCE extends zio.aws.panorama.model.DeviceType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.DeviceType =
      software.amazon.awssdk.services.panorama.model.DeviceType.PANORAMA_APPLIANCE
  }
}
