package zio.aws.panorama.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EthernetPayload(
    connectionType: zio.aws.panorama.model.ConnectionType,
    staticIpConnectionInfo: Optional[
      zio.aws.panorama.model.StaticIpConnectionInfo
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.EthernetPayload = {
    import EthernetPayload.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.EthernetPayload
      .builder()
      .connectionType(connectionType.unwrap)
      .optionallyWith(
        staticIpConnectionInfo.map(value => value.buildAwsValue())
      )(_.staticIpConnectionInfo)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.EthernetPayload.ReadOnly =
    zio.aws.panorama.model.EthernetPayload.wrap(buildAwsValue())
}
object EthernetPayload {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.EthernetPayload
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.EthernetPayload =
      zio.aws.panorama.model.EthernetPayload(
        connectionType,
        staticIpConnectionInfo.map(value => value.asEditable)
      )
    def connectionType: zio.aws.panorama.model.ConnectionType
    def staticIpConnectionInfo
        : Optional[zio.aws.panorama.model.StaticIpConnectionInfo.ReadOnly]
    def getConnectionType
        : ZIO[Any, Nothing, zio.aws.panorama.model.ConnectionType] =
      ZIO.succeed(connectionType)
    def getStaticIpConnectionInfo: ZIO[
      Any,
      AwsError,
      zio.aws.panorama.model.StaticIpConnectionInfo.ReadOnly
    ] = AwsError.unwrapOptionField(
      "staticIpConnectionInfo",
      staticIpConnectionInfo
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.EthernetPayload
  ) extends zio.aws.panorama.model.EthernetPayload.ReadOnly {
    override val connectionType: zio.aws.panorama.model.ConnectionType =
      zio.aws.panorama.model.ConnectionType.wrap(impl.connectionType())
    override val staticIpConnectionInfo
        : Optional[zio.aws.panorama.model.StaticIpConnectionInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.staticIpConnectionInfo())
        .map(value => zio.aws.panorama.model.StaticIpConnectionInfo.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.EthernetPayload
  ): zio.aws.panorama.model.EthernetPayload.ReadOnly = new Wrapper(impl)
}
