package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{IpAddress, HwAddress}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class EthernetStatus(
    connectionStatus: Optional[zio.aws.panorama.model.NetworkConnectionStatus] =
      Optional.Absent,
    hwAddress: Optional[HwAddress] = Optional.Absent,
    ipAddress: Optional[IpAddress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.EthernetStatus = {
    import EthernetStatus.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.EthernetStatus
      .builder()
      .optionallyWith(connectionStatus.map(value => value.unwrap))(
        _.connectionStatus
      )
      .optionallyWith(
        hwAddress.map(value => HwAddress.unwrap(value): java.lang.String)
      )(_.hwAddress)
      .optionallyWith(
        ipAddress.map(value => IpAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.EthernetStatus.ReadOnly =
    zio.aws.panorama.model.EthernetStatus.wrap(buildAwsValue())
}
object EthernetStatus {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.EthernetStatus
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.EthernetStatus =
      zio.aws.panorama.model.EthernetStatus(
        connectionStatus.map(value => value),
        hwAddress.map(value => value),
        ipAddress.map(value => value)
      )
    def connectionStatus
        : Optional[zio.aws.panorama.model.NetworkConnectionStatus]
    def hwAddress: Optional[HwAddress]
    def ipAddress: Optional[IpAddress]
    def getConnectionStatus
        : ZIO[Any, AwsError, zio.aws.panorama.model.NetworkConnectionStatus] =
      AwsError.unwrapOptionField("connectionStatus", connectionStatus)
    def getHwAddress: ZIO[Any, AwsError, HwAddress] =
      AwsError.unwrapOptionField("hwAddress", hwAddress)
    def getIpAddress: ZIO[Any, AwsError, IpAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.EthernetStatus
  ) extends zio.aws.panorama.model.EthernetStatus.ReadOnly {
    override val connectionStatus
        : Optional[zio.aws.panorama.model.NetworkConnectionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionStatus())
        .map(value =>
          zio.aws.panorama.model.NetworkConnectionStatus.wrap(value)
        )
    override val hwAddress: Optional[HwAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.hwAddress())
      .map(value => zio.aws.panorama.model.primitives.HwAddress(value))
    override val ipAddress: Optional[IpAddress] = zio.aws.core.internal
      .optionalFromNullable(impl.ipAddress())
      .map(value => zio.aws.panorama.model.primitives.IpAddress(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.EthernetStatus
  ): zio.aws.panorama.model.EthernetStatus.ReadOnly = new Wrapper(impl)
}
