package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{JobId, DeviceId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Job(
    deviceId: Optional[DeviceId] = Optional.Absent,
    jobId: Optional[JobId] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.panorama.model.Job = {
    import Job.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.Job
      .builder()
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        jobId.map(value => JobId.unwrap(value): java.lang.String)
      )(_.jobId)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.Job.ReadOnly =
    zio.aws.panorama.model.Job.wrap(buildAwsValue())
}
object Job {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.panorama.model.Job] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.Job = zio.aws.panorama.model
      .Job(deviceId.map(value => value), jobId.map(value => value))
    def deviceId: Optional[DeviceId]
    def jobId: Optional[JobId]
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getJobId: ZIO[Any, AwsError, JobId] =
      AwsError.unwrapOptionField("jobId", jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.Job
  ) extends zio.aws.panorama.model.Job.ReadOnly {
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
    override val jobId: Optional[JobId] = zio.aws.core.internal
      .optionalFromNullable(impl.jobId())
      .map(value => zio.aws.panorama.model.primitives.JobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.Job
  ): zio.aws.panorama.model.Job.ReadOnly = new Wrapper(impl)
}
