package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.{TagValue, TagKey}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class JobResourceTags(
    resourceType: zio.aws.panorama.model.JobResourceType,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.JobResourceTags = {
    import JobResourceTags.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.JobResourceTags
      .builder()
      .resourceType(resourceType.unwrap)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.JobResourceTags.ReadOnly =
    zio.aws.panorama.model.JobResourceTags.wrap(buildAwsValue())
}
object JobResourceTags {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.JobResourceTags
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.JobResourceTags =
      zio.aws.panorama.model.JobResourceTags(resourceType, tags)
    def resourceType: zio.aws.panorama.model.JobResourceType
    def tags: Map[TagKey, TagValue]
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.panorama.model.JobResourceType] =
      ZIO.succeed(resourceType)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.JobResourceTags
  ) extends zio.aws.panorama.model.JobResourceTags.ReadOnly {
    override val resourceType: zio.aws.panorama.model.JobResourceType =
      zio.aws.panorama.model.JobResourceType.wrap(impl.resourceType())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.panorama.model.primitives
          .TagKey(key) -> zio.aws.panorama.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.JobResourceTags
  ): zio.aws.panorama.model.JobResourceTags.ReadOnly = new Wrapper(impl)
}
