package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait JobResourceType {
  def unwrap: software.amazon.awssdk.services.panorama.model.JobResourceType
}
object JobResourceType {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.JobResourceType
  ): zio.aws.panorama.model.JobResourceType = value match {
    case software.amazon.awssdk.services.panorama.model.JobResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.JobResourceType.PACKAGE =>
      val r = PACKAGE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.panorama.model.JobResourceType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.JobResourceType =
      software.amazon.awssdk.services.panorama.model.JobResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object PACKAGE extends zio.aws.panorama.model.JobResourceType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.JobResourceType =
      software.amazon.awssdk.services.panorama.model.JobResourceType.PACKAGE
  }
}
