package zio.aws.panorama.model
import scala.jdk.CollectionConverters._
sealed trait JobType {
  def unwrap: software.amazon.awssdk.services.panorama.model.JobType
}
object JobType {
  def wrap(
      value: software.amazon.awssdk.services.panorama.model.JobType
  ): zio.aws.panorama.model.JobType = value match {
    case software.amazon.awssdk.services.panorama.model.JobType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.panorama.model.JobType.OTA =>
      val r = OTA
      r
    case software.amazon.awssdk.services.panorama.model.JobType.REBOOT =>
      val r = REBOOT
      r
  }
  case object unknownToSdkVersion extends zio.aws.panorama.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.JobType =
      software.amazon.awssdk.services.panorama.model.JobType.UNKNOWN_TO_SDK_VERSION
  }
  case object OTA extends zio.aws.panorama.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.JobType =
      software.amazon.awssdk.services.panorama.model.JobType.OTA
  }
  case object REBOOT extends zio.aws.panorama.model.JobType {
    override def unwrap
        : software.amazon.awssdk.services.panorama.model.JobType =
      software.amazon.awssdk.services.panorama.model.JobType.REBOOT
  }
}
