package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.ImageVersion
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class LatestDeviceJob(
    imageVersion: Optional[ImageVersion] = Optional.Absent,
    jobType: Optional[zio.aws.panorama.model.JobType] = Optional.Absent,
    status: Optional[zio.aws.panorama.model.UpdateProgress] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.LatestDeviceJob = {
    import LatestDeviceJob.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.LatestDeviceJob
      .builder()
      .optionallyWith(
        imageVersion.map(value => ImageVersion.unwrap(value): java.lang.String)
      )(_.imageVersion)
      .optionallyWith(jobType.map(value => value.unwrap))(_.jobType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.panorama.model.LatestDeviceJob.ReadOnly =
    zio.aws.panorama.model.LatestDeviceJob.wrap(buildAwsValue())
}
object LatestDeviceJob {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.LatestDeviceJob
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.LatestDeviceJob =
      zio.aws.panorama.model.LatestDeviceJob(
        imageVersion.map(value => value),
        jobType.map(value => value),
        status.map(value => value)
      )
    def imageVersion: Optional[ImageVersion]
    def jobType: Optional[zio.aws.panorama.model.JobType]
    def status: Optional[zio.aws.panorama.model.UpdateProgress]
    def getImageVersion: ZIO[Any, AwsError, ImageVersion] =
      AwsError.unwrapOptionField("imageVersion", imageVersion)
    def getJobType: ZIO[Any, AwsError, zio.aws.panorama.model.JobType] =
      AwsError.unwrapOptionField("jobType", jobType)
    def getStatus: ZIO[Any, AwsError, zio.aws.panorama.model.UpdateProgress] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.LatestDeviceJob
  ) extends zio.aws.panorama.model.LatestDeviceJob.ReadOnly {
    override val imageVersion: Optional[ImageVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.imageVersion())
      .map(value => zio.aws.panorama.model.primitives.ImageVersion(value))
    override val jobType: Optional[zio.aws.panorama.model.JobType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jobType())
        .map(value => zio.aws.panorama.model.JobType.wrap(value))
    override val status: Optional[zio.aws.panorama.model.UpdateProgress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.panorama.model.UpdateProgress.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.LatestDeviceJob
  ): zio.aws.panorama.model.LatestDeviceJob.ReadOnly = new Wrapper(impl)
}
