package zio.aws.panorama.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{
  NextToken,
  MaxSize25,
  ApplicationInstanceId
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListApplicationInstanceDependenciesRequest(
    applicationInstanceId: ApplicationInstanceId,
    maxResults: Optional[MaxSize25] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest = {
    import ListApplicationInstanceDependenciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest
      .builder()
      .applicationInstanceId(
        ApplicationInstanceId.unwrap(applicationInstanceId): java.lang.String
      )
      .optionallyWith(
        maxResults.map(value => MaxSize25.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest.ReadOnly =
    zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest
      .wrap(buildAwsValue())
}
object ListApplicationInstanceDependenciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest =
      zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest(
        applicationInstanceId,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def applicationInstanceId: ApplicationInstanceId
    def maxResults: Optional[MaxSize25]
    def nextToken: Optional[NextToken]
    def getApplicationInstanceId: ZIO[Any, Nothing, ApplicationInstanceId] =
      ZIO.succeed(applicationInstanceId)
    def getMaxResults: ZIO[Any, AwsError, MaxSize25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest
  ) extends zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest.ReadOnly {
    override val applicationInstanceId: ApplicationInstanceId =
      zio.aws.panorama.model.primitives
        .ApplicationInstanceId(impl.applicationInstanceId())
    override val maxResults: Optional[MaxSize25] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.panorama.model.primitives.MaxSize25(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesRequest
  ): zio.aws.panorama.model.ListApplicationInstanceDependenciesRequest.ReadOnly =
    new Wrapper(impl)
}
