package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationInstanceDependenciesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    packageObjects: Optional[Iterable[zio.aws.panorama.model.PackageObject]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse = {
    import ListApplicationInstanceDependenciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        packageObjects.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.packageObjects)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.ReadOnly =
    zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse
      .wrap(buildAwsValue())
}
object ListApplicationInstanceDependenciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse =
      zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse(
        nextToken.map(value => value),
        packageObjects.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def packageObjects
        : Optional[List[zio.aws.panorama.model.PackageObject.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getPackageObjects: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.PackageObject.ReadOnly
    ]] = AwsError.unwrapOptionField("packageObjects", packageObjects)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse
  ) extends zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
    override val packageObjects
        : Optional[List[zio.aws.panorama.model.PackageObject.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.packageObjects())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.PackageObject.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstanceDependenciesResponse
  ): zio.aws.panorama.model.ListApplicationInstanceDependenciesResponse.ReadOnly =
    new Wrapper(impl)
}
