package zio.aws.panorama.model
import zio.ZIO
import zio.aws.panorama.model.primitives.NextToken
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListApplicationInstanceNodeInstancesResponse(
    nextToken: Optional[NextToken] = Optional.Absent,
    nodeInstances: Optional[Iterable[zio.aws.panorama.model.NodeInstance]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse = {
    import ListApplicationInstanceNodeInstancesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse
      .builder()
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        nodeInstances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.nodeInstances)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.ReadOnly =
    zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse
      .wrap(buildAwsValue())
}
object ListApplicationInstanceNodeInstancesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse =
      zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse(
        nextToken.map(value => value),
        nodeInstances.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextToken: Optional[NextToken]
    def nodeInstances
        : Optional[List[zio.aws.panorama.model.NodeInstance.ReadOnly]]
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getNodeInstances: ZIO[Any, AwsError, List[
      zio.aws.panorama.model.NodeInstance.ReadOnly
    ]] = AwsError.unwrapOptionField("nodeInstances", nodeInstances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse
  ) extends zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.ReadOnly {
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
    override val nodeInstances
        : Optional[List[zio.aws.panorama.model.NodeInstance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nodeInstances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.panorama.model.NodeInstance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstanceNodeInstancesResponse
  ): zio.aws.panorama.model.ListApplicationInstanceNodeInstancesResponse.ReadOnly =
    new Wrapper(impl)
}
