package zio.aws.panorama.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.panorama.model.primitives.{NextToken, MaxSize25, DeviceId}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListApplicationInstancesRequest(
    deviceId: Optional[DeviceId] = Optional.Absent,
    maxResults: Optional[MaxSize25] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    statusFilter: Optional[zio.aws.panorama.model.StatusFilter] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest = {
    import ListApplicationInstancesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest
      .builder()
      .optionallyWith(
        deviceId.map(value => DeviceId.unwrap(value): java.lang.String)
      )(_.deviceId)
      .optionallyWith(
        maxResults.map(value => MaxSize25.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(statusFilter.map(value => value.unwrap))(_.statusFilter)
      .build()
  }
  def asReadOnly
      : zio.aws.panorama.model.ListApplicationInstancesRequest.ReadOnly =
    zio.aws.panorama.model.ListApplicationInstancesRequest.wrap(buildAwsValue())
}
object ListApplicationInstancesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.panorama.model.ListApplicationInstancesRequest =
      zio.aws.panorama.model.ListApplicationInstancesRequest(
        deviceId.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value),
        statusFilter.map(value => value)
      )
    def deviceId: Optional[DeviceId]
    def maxResults: Optional[MaxSize25]
    def nextToken: Optional[NextToken]
    def statusFilter: Optional[zio.aws.panorama.model.StatusFilter]
    def getDeviceId: ZIO[Any, AwsError, DeviceId] =
      AwsError.unwrapOptionField("deviceId", deviceId)
    def getMaxResults: ZIO[Any, AwsError, MaxSize25] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getStatusFilter
        : ZIO[Any, AwsError, zio.aws.panorama.model.StatusFilter] =
      AwsError.unwrapOptionField("statusFilter", statusFilter)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest
  ) extends zio.aws.panorama.model.ListApplicationInstancesRequest.ReadOnly {
    override val deviceId: Optional[DeviceId] = zio.aws.core.internal
      .optionalFromNullable(impl.deviceId())
      .map(value => zio.aws.panorama.model.primitives.DeviceId(value))
    override val maxResults: Optional[MaxSize25] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.panorama.model.primitives.MaxSize25(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.panorama.model.primitives.NextToken(value))
    override val statusFilter: Optional[zio.aws.panorama.model.StatusFilter] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusFilter())
        .map(value => zio.aws.panorama.model.StatusFilter.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.panorama.model.ListApplicationInstancesRequest
  ): zio.aws.panorama.model.ListApplicationInstancesRequest.ReadOnly =
    new Wrapper(impl)
}
